/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationItem.Builder, RecommendationItem> {
    private static final SdkField<Boolean> ALREADY_IMPLEMENTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("alreadyImplemented").getter(getter(RecommendationItem::alreadyImplemented))
            .setter(setter(Builder::alreadyImplemented))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alreadyImplemented").build())
            .build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(RecommendationItem::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetAccountId").getter(getter(RecommendationItem::targetAccountId))
            .setter(setter(Builder::targetAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountId").build()).build();

    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRegion").getter(getter(RecommendationItem::targetRegion)).setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALREADY_IMPLEMENTED_FIELD,
            RESOURCE_ID_FIELD, TARGET_ACCOUNT_ID_FIELD, TARGET_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean alreadyImplemented;

    private final String resourceId;

    private final String targetAccountId;

    private final String targetRegion;

    private RecommendationItem(BuilderImpl builder) {
        this.alreadyImplemented = builder.alreadyImplemented;
        this.resourceId = builder.resourceId;
        this.targetAccountId = builder.targetAccountId;
        this.targetRegion = builder.targetRegion;
    }

    /**
     * <p>
     * Specifies if the recommendation has already been implemented.
     * </p>
     * 
     * @return Specifies if the recommendation has already been implemented.
     */
    public final Boolean alreadyImplemented() {
        return alreadyImplemented;
    }

    /**
     * <p>
     * The resource identifier.
     * </p>
     * 
     * @return The resource identifier.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The target account identifier.
     * </p>
     * 
     * @return The target account identifier.
     */
    public final String targetAccountId() {
        return targetAccountId;
    }

    /**
     * <p>
     * The target region.
     * </p>
     * 
     * @return The target region.
     */
    public final String targetRegion() {
        return targetRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alreadyImplemented());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationItem)) {
            return false;
        }
        RecommendationItem other = (RecommendationItem) obj;
        return Objects.equals(alreadyImplemented(), other.alreadyImplemented())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(targetAccountId(), other.targetAccountId())
                && Objects.equals(targetRegion(), other.targetRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationItem").add("AlreadyImplemented", alreadyImplemented())
                .add("ResourceId", resourceId()).add("TargetAccountId", targetAccountId()).add("TargetRegion", targetRegion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alreadyImplemented":
            return Optional.ofNullable(clazz.cast(alreadyImplemented()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "targetAccountId":
            return Optional.ofNullable(clazz.cast(targetAccountId()));
        case "targetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationItem, T> g) {
        return obj -> g.apply((RecommendationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationItem> {
        /**
         * <p>
         * Specifies if the recommendation has already been implemented.
         * </p>
         * 
         * @param alreadyImplemented
         *        Specifies if the recommendation has already been implemented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alreadyImplemented(Boolean alreadyImplemented);

        /**
         * <p>
         * The resource identifier.
         * </p>
         * 
         * @param resourceId
         *        The resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The target account identifier.
         * </p>
         * 
         * @param targetAccountId
         *        The target account identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountId(String targetAccountId);

        /**
         * <p>
         * The target region.
         * </p>
         * 
         * @param targetRegion
         *        The target region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);
    }

    static final class BuilderImpl implements Builder {
        private Boolean alreadyImplemented;

        private String resourceId;

        private String targetAccountId;

        private String targetRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationItem model) {
            alreadyImplemented(model.alreadyImplemented);
            resourceId(model.resourceId);
            targetAccountId(model.targetAccountId);
            targetRegion(model.targetRegion);
        }

        public final Boolean getAlreadyImplemented() {
            return alreadyImplemented;
        }

        public final void setAlreadyImplemented(Boolean alreadyImplemented) {
            this.alreadyImplemented = alreadyImplemented;
        }

        @Override
        public final Builder alreadyImplemented(Boolean alreadyImplemented) {
            this.alreadyImplemented = alreadyImplemented;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getTargetAccountId() {
            return targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        @Override
        public RecommendationItem build() {
            return new RecommendationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
