/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecommendationTemplateRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<CreateRecommendationTemplateRequest.Builder, CreateRecommendationTemplateRequest> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentArn").getter(getter(CreateRecommendationTemplateRequest::assessmentArn))
            .setter(setter(Builder::assessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(CreateRecommendationTemplateRequest::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateRecommendationTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(CreateRecommendationTemplateRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRecommendationTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendationIds")
            .getter(getter(CreateRecommendationTemplateRequest::recommendationIds))
            .setter(setter(Builder::recommendationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RECOMMENDATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendationTypes")
            .getter(getter(CreateRecommendationTemplateRequest::recommendationTypesAsStrings))
            .setter(setter(Builder::recommendationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRecommendationTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ARN_FIELD,
            BUCKET_NAME_FIELD, CLIENT_TOKEN_FIELD, FORMAT_FIELD, NAME_FIELD, RECOMMENDATION_IDS_FIELD,
            RECOMMENDATION_TYPES_FIELD, TAGS_FIELD));

    private final String assessmentArn;

    private final String bucketName;

    private final String clientToken;

    private final String format;

    private final String name;

    private final List<String> recommendationIds;

    private final List<String> recommendationTypes;

    private final Map<String, String> tags;

    private CreateRecommendationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
        this.bucketName = builder.bucketName;
        this.clientToken = builder.clientToken;
        this.format = builder.format;
        this.name = builder.name;
        this.recommendationIds = builder.recommendationIds;
        this.recommendationTypes = builder.recommendationTypes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information
     * about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
     * Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
     *         information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String assessmentArn() {
        return assessmentArn;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket that will contain the recommendation template.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket that will contain the recommendation template.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
     * You should not reuse the same client token for other API requests.
     * </p>
     * 
     * @return Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
     *         characters. You should not reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The format for the recommendation template.
     * </p>
     * <dl>
     * <dt>CfnJson</dt>
     * <dd>
     * <p>
     * The template is CloudFormation JSON.
     * </p>
     * </dd>
     * <dt>CfnYaml</dt>
     * <dd>
     * <p>
     * The template is CloudFormation YAML.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format for the recommendation template.</p>
     *         <dl>
     *         <dt>CfnJson</dt>
     *         <dd>
     *         <p>
     *         The template is CloudFormation JSON.
     *         </p>
     *         </dd>
     *         <dt>CfnYaml</dt>
     *         <dd>
     *         <p>
     *         The template is CloudFormation YAML.
     *         </p>
     *         </dd>
     * @see TemplateFormat
     */
    public final TemplateFormat format() {
        return TemplateFormat.fromValue(format);
    }

    /**
     * <p>
     * The format for the recommendation template.
     * </p>
     * <dl>
     * <dt>CfnJson</dt>
     * <dd>
     * <p>
     * The template is CloudFormation JSON.
     * </p>
     * </dd>
     * <dt>CfnYaml</dt>
     * <dd>
     * <p>
     * The template is CloudFormation YAML.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format for the recommendation template.</p>
     *         <dl>
     *         <dt>CfnJson</dt>
     *         <dd>
     *         <p>
     *         The template is CloudFormation JSON.
     *         </p>
     *         </dd>
     *         <dt>CfnYaml</dt>
     *         <dd>
     *         <p>
     *         The template is CloudFormation YAML.
     *         </p>
     *         </dd>
     * @see TemplateFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The name for the recommendation template.
     * </p>
     * 
     * @return The name for the recommendation template.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendationIds() {
        return recommendationIds != null && !(recommendationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifiers for the recommendations used to create a recommendation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationIds} method.
     * </p>
     * 
     * @return Identifiers for the recommendations used to create a recommendation template.
     */
    public final List<String> recommendationIds() {
        return recommendationIds;
    }

    /**
     * <p>
     * An array of strings that specify the recommendation template type or types.
     * </p>
     * <dl>
     * <dt>Alarm</dt>
     * <dd>
     * <p>
     * The template is an <a>AlarmRecommendation</a> template.
     * </p>
     * </dd>
     * <dt>Sop</dt>
     * <dd>
     * <p>
     * The template is a <a>SopRecommendation</a> template.
     * </p>
     * </dd>
     * <dt>Test</dt>
     * <dd>
     * <p>
     * The template is a <a>TestRecommendation</a> template.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationTypes} method.
     * </p>
     * 
     * @return An array of strings that specify the recommendation template type or types.</p>
     *         <dl>
     *         <dt>Alarm</dt>
     *         <dd>
     *         <p>
     *         The template is an <a>AlarmRecommendation</a> template.
     *         </p>
     *         </dd>
     *         <dt>Sop</dt>
     *         <dd>
     *         <p>
     *         The template is a <a>SopRecommendation</a> template.
     *         </p>
     *         </dd>
     *         <dt>Test</dt>
     *         <dd>
     *         <p>
     *         The template is a <a>TestRecommendation</a> template.
     *         </p>
     *         </dd>
     */
    public final List<RenderRecommendationType> recommendationTypes() {
        return RenderRecommendationTypeListCopier.copyStringToEnum(recommendationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendationTypes() {
        return recommendationTypes != null && !(recommendationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that specify the recommendation template type or types.
     * </p>
     * <dl>
     * <dt>Alarm</dt>
     * <dd>
     * <p>
     * The template is an <a>AlarmRecommendation</a> template.
     * </p>
     * </dd>
     * <dt>Sop</dt>
     * <dd>
     * <p>
     * The template is a <a>SopRecommendation</a> template.
     * </p>
     * </dd>
     * <dt>Test</dt>
     * <dd>
     * <p>
     * The template is a <a>TestRecommendation</a> template.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationTypes} method.
     * </p>
     * 
     * @return An array of strings that specify the recommendation template type or types.</p>
     *         <dl>
     *         <dt>Alarm</dt>
     *         <dd>
     *         <p>
     *         The template is an <a>AlarmRecommendation</a> template.
     *         </p>
     *         </dd>
     *         <dt>Sop</dt>
     *         <dd>
     *         <p>
     *         The template is a <a>SopRecommendation</a> template.
     *         </p>
     *         </dd>
     *         <dt>Test</dt>
     *         <dd>
     *         <p>
     *         The template is a <a>TestRecommendation</a> template.
     *         </p>
     *         </dd>
     */
    public final List<String> recommendationTypesAsStrings() {
        return recommendationTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
     *         Each tag consists of a key/value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationIds() ? recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationTypes() ? recommendationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommendationTemplateRequest)) {
            return false;
        }
        CreateRecommendationTemplateRequest other = (CreateRecommendationTemplateRequest) obj;
        return Objects.equals(assessmentArn(), other.assessmentArn()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(name(), other.name()) && hasRecommendationIds() == other.hasRecommendationIds()
                && Objects.equals(recommendationIds(), other.recommendationIds())
                && hasRecommendationTypes() == other.hasRecommendationTypes()
                && Objects.equals(recommendationTypesAsStrings(), other.recommendationTypesAsStrings())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRecommendationTemplateRequest").add("AssessmentArn", assessmentArn())
                .add("BucketName", bucketName()).add("ClientToken", clientToken()).add("Format", formatAsString())
                .add("Name", name()).add("RecommendationIds", hasRecommendationIds() ? recommendationIds() : null)
                .add("RecommendationTypes", hasRecommendationTypes() ? recommendationTypesAsStrings() : null)
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentArn":
            return Optional.ofNullable(clazz.cast(assessmentArn()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recommendationIds":
            return Optional.ofNullable(clazz.cast(recommendationIds()));
        case "recommendationTypes":
            return Optional.ofNullable(clazz.cast(recommendationTypesAsStrings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommendationTemplateRequest, T> g) {
        return obj -> g.apply((CreateRecommendationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRecommendationTemplateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param assessmentArn
         *        The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/
         *        <code>app-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentArn(String assessmentArn);

        /**
         * <p>
         * The name of the Amazon S3 bucket that will contain the recommendation template.
         * </p>
         * 
         * @param bucketName
         *        The name of the Amazon S3 bucket that will contain the recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         * characters. You should not reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         *        characters. You should not reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The format for the recommendation template.
         * </p>
         * <dl>
         * <dt>CfnJson</dt>
         * <dd>
         * <p>
         * The template is CloudFormation JSON.
         * </p>
         * </dd>
         * <dt>CfnYaml</dt>
         * <dd>
         * <p>
         * The template is CloudFormation YAML.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param format
         *        The format for the recommendation template.</p>
         *        <dl>
         *        <dt>CfnJson</dt>
         *        <dd>
         *        <p>
         *        The template is CloudFormation JSON.
         *        </p>
         *        </dd>
         *        <dt>CfnYaml</dt>
         *        <dd>
         *        <p>
         *        The template is CloudFormation YAML.
         *        </p>
         *        </dd>
         * @see TemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format for the recommendation template.
         * </p>
         * <dl>
         * <dt>CfnJson</dt>
         * <dd>
         * <p>
         * The template is CloudFormation JSON.
         * </p>
         * </dd>
         * <dt>CfnYaml</dt>
         * <dd>
         * <p>
         * The template is CloudFormation YAML.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param format
         *        The format for the recommendation template.</p>
         *        <dl>
         *        <dt>CfnJson</dt>
         *        <dd>
         *        <p>
         *        The template is CloudFormation JSON.
         *        </p>
         *        </dd>
         *        <dt>CfnYaml</dt>
         *        <dd>
         *        <p>
         *        The template is CloudFormation YAML.
         *        </p>
         *        </dd>
         * @see TemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateFormat
         */
        Builder format(TemplateFormat format);

        /**
         * <p>
         * The name for the recommendation template.
         * </p>
         * 
         * @param name
         *        The name for the recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Identifiers for the recommendations used to create a recommendation template.
         * </p>
         * 
         * @param recommendationIds
         *        Identifiers for the recommendations used to create a recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIds(Collection<String> recommendationIds);

        /**
         * <p>
         * Identifiers for the recommendations used to create a recommendation template.
         * </p>
         * 
         * @param recommendationIds
         *        Identifiers for the recommendations used to create a recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIds(String... recommendationIds);

        /**
         * <p>
         * An array of strings that specify the recommendation template type or types.
         * </p>
         * <dl>
         * <dt>Alarm</dt>
         * <dd>
         * <p>
         * The template is an <a>AlarmRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Sop</dt>
         * <dd>
         * <p>
         * The template is a <a>SopRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Test</dt>
         * <dd>
         * <p>
         * The template is a <a>TestRecommendation</a> template.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param recommendationTypes
         *        An array of strings that specify the recommendation template type or types.</p>
         *        <dl>
         *        <dt>Alarm</dt>
         *        <dd>
         *        <p>
         *        The template is an <a>AlarmRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Sop</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>SopRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Test</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>TestRecommendation</a> template.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTypesWithStrings(Collection<String> recommendationTypes);

        /**
         * <p>
         * An array of strings that specify the recommendation template type or types.
         * </p>
         * <dl>
         * <dt>Alarm</dt>
         * <dd>
         * <p>
         * The template is an <a>AlarmRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Sop</dt>
         * <dd>
         * <p>
         * The template is a <a>SopRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Test</dt>
         * <dd>
         * <p>
         * The template is a <a>TestRecommendation</a> template.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param recommendationTypes
         *        An array of strings that specify the recommendation template type or types.</p>
         *        <dl>
         *        <dt>Alarm</dt>
         *        <dd>
         *        <p>
         *        The template is an <a>AlarmRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Sop</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>SopRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Test</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>TestRecommendation</a> template.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTypesWithStrings(String... recommendationTypes);

        /**
         * <p>
         * An array of strings that specify the recommendation template type or types.
         * </p>
         * <dl>
         * <dt>Alarm</dt>
         * <dd>
         * <p>
         * The template is an <a>AlarmRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Sop</dt>
         * <dd>
         * <p>
         * The template is a <a>SopRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Test</dt>
         * <dd>
         * <p>
         * The template is a <a>TestRecommendation</a> template.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param recommendationTypes
         *        An array of strings that specify the recommendation template type or types.</p>
         *        <dl>
         *        <dt>Alarm</dt>
         *        <dd>
         *        <p>
         *        The template is an <a>AlarmRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Sop</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>SopRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Test</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>TestRecommendation</a> template.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTypes(Collection<RenderRecommendationType> recommendationTypes);

        /**
         * <p>
         * An array of strings that specify the recommendation template type or types.
         * </p>
         * <dl>
         * <dt>Alarm</dt>
         * <dd>
         * <p>
         * The template is an <a>AlarmRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Sop</dt>
         * <dd>
         * <p>
         * The template is a <a>SopRecommendation</a> template.
         * </p>
         * </dd>
         * <dt>Test</dt>
         * <dd>
         * <p>
         * The template is a <a>TestRecommendation</a> template.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param recommendationTypes
         *        An array of strings that specify the recommendation template type or types.</p>
         *        <dl>
         *        <dt>Alarm</dt>
         *        <dd>
         *        <p>
         *        The template is an <a>AlarmRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Sop</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>SopRecommendation</a> template.
         *        </p>
         *        </dd>
         *        <dt>Test</dt>
         *        <dd>
         *        <p>
         *        The template is a <a>TestRecommendation</a> template.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTypes(RenderRecommendationType... recommendationTypes);

        /**
         * <p>
         * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each
         * tag consists of a key/value pair.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String assessmentArn;

        private String bucketName;

        private String clientToken;

        private String format;

        private String name;

        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> recommendationTypes = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommendationTemplateRequest model) {
            super(model);
            assessmentArn(model.assessmentArn);
            bucketName(model.bucketName);
            clientToken(model.clientToken);
            format(model.format);
            name(model.name);
            recommendationIds(model.recommendationIds);
            recommendationTypesWithStrings(model.recommendationTypes);
            tags(model.tags);
        }

        public final String getAssessmentArn() {
            return assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TemplateFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String... recommendationIds) {
            recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final Collection<String> getRecommendationTypes() {
            if (recommendationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendationTypes;
        }

        public final void setRecommendationTypes(Collection<String> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copy(recommendationTypes);
        }

        @Override
        public final Builder recommendationTypesWithStrings(Collection<String> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copy(recommendationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTypesWithStrings(String... recommendationTypes) {
            recommendationTypesWithStrings(Arrays.asList(recommendationTypes));
            return this;
        }

        @Override
        public final Builder recommendationTypes(Collection<RenderRecommendationType> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copyEnumToString(recommendationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTypes(RenderRecommendationType... recommendationTypes) {
            recommendationTypes(Arrays.asList(recommendationTypes));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecommendationTemplateRequest build() {
            return new CreateRecommendationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
