/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppAssessmentResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<DeleteAppAssessmentResponse.Builder, DeleteAppAssessmentResponse> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentArn").getter(getter(DeleteAppAssessmentResponse::assessmentArn))
            .setter(setter(Builder::assessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()).build();

    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentStatus").getter(getter(DeleteAppAssessmentResponse::assessmentStatusAsString))
            .setter(setter(Builder::assessmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ARN_FIELD,
            ASSESSMENT_STATUS_FIELD));

    private final String assessmentArn;

    private final String assessmentStatus;

    private DeleteAppAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
        this.assessmentStatus = builder.assessmentStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information
     * about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
     * Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
     *         information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String assessmentArn() {
        return assessmentArn;
    }

    /**
     * <p>
     * The current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assessmentStatus}
     * will return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assessmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the assessment for the resiliency policy.
     * @see AssessmentStatus
     */
    public final AssessmentStatus assessmentStatus() {
        return AssessmentStatus.fromValue(assessmentStatus);
    }

    /**
     * <p>
     * The current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assessmentStatus}
     * will return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assessmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the assessment for the resiliency policy.
     * @see AssessmentStatus
     */
    public final String assessmentStatusAsString() {
        return assessmentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppAssessmentResponse)) {
            return false;
        }
        DeleteAppAssessmentResponse other = (DeleteAppAssessmentResponse) obj;
        return Objects.equals(assessmentArn(), other.assessmentArn())
                && Objects.equals(assessmentStatusAsString(), other.assessmentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAppAssessmentResponse").add("AssessmentArn", assessmentArn())
                .add("AssessmentStatus", assessmentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentArn":
            return Optional.ofNullable(clazz.cast(assessmentArn()));
        case "assessmentStatus":
            return Optional.ofNullable(clazz.cast(assessmentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppAssessmentResponse, T> g) {
        return obj -> g.apply((DeleteAppAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAppAssessmentResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param assessmentArn
         *        The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/
         *        <code>app-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentArn(String assessmentArn);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder assessmentStatus(String assessmentStatus);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder assessmentStatus(AssessmentStatus assessmentStatus);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String assessmentArn;

        private String assessmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppAssessmentResponse model) {
            super(model);
            assessmentArn(model.assessmentArn);
            assessmentStatus(model.assessmentStatus);
        }

        public final String getAssessmentArn() {
            return assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getAssessmentStatus() {
            return assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        @Override
        public final Builder assessmentStatus(AssessmentStatus assessmentStatus) {
            this.assessmentStatus(assessmentStatus == null ? null : assessmentStatus.toString());
            return this;
        }

        @Override
        public DeleteAppAssessmentResponse build() {
            return new DeleteAppAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
