/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettings;
import software.amazon.awssdk.services.rekognition.model.FaceSearchSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamProcessorSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamProcessorSettings> {
    private static final SdkField<FaceSearchSettings> FACE_SEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FaceSearch").getter(StreamProcessorSettings.getter(StreamProcessorSettings::faceSearch)).setter(StreamProcessorSettings.setter(Builder::faceSearch)).constructor(FaceSearchSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceSearch").build()}).build();
    private static final SdkField<ConnectedHomeSettings> CONNECTED_HOME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectedHome").getter(StreamProcessorSettings.getter(StreamProcessorSettings::connectedHome)).setter(StreamProcessorSettings.setter(Builder::connectedHome)).constructor(ConnectedHomeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedHome").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_SEARCH_FIELD, CONNECTED_HOME_FIELD));
    private static final long serialVersionUID = 1L;
    private final FaceSearchSettings faceSearch;
    private final ConnectedHomeSettings connectedHome;

    private StreamProcessorSettings(BuilderImpl builder) {
        this.faceSearch = builder.faceSearch;
        this.connectedHome = builder.connectedHome;
    }

    public final FaceSearchSettings faceSearch() {
        return this.faceSearch;
    }

    public final ConnectedHomeSettings connectedHome() {
        return this.connectedHome;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceSearch());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedHome());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorSettings)) {
            return false;
        }
        StreamProcessorSettings other = (StreamProcessorSettings)obj;
        return Objects.equals(this.faceSearch(), other.faceSearch()) && Objects.equals(this.connectedHome(), other.connectedHome());
    }

    public final String toString() {
        return ToString.builder((String)"StreamProcessorSettings").add("FaceSearch", (Object)this.faceSearch()).add("ConnectedHome", (Object)this.connectedHome()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceSearch": {
                return Optional.ofNullable(clazz.cast(this.faceSearch()));
            }
            case "ConnectedHome": {
                return Optional.ofNullable(clazz.cast(this.connectedHome()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorSettings, T> g) {
        return obj -> g.apply((StreamProcessorSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FaceSearchSettings faceSearch;
        private ConnectedHomeSettings connectedHome;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorSettings model) {
            this.faceSearch(model.faceSearch);
            this.connectedHome(model.connectedHome);
        }

        public final FaceSearchSettings.Builder getFaceSearch() {
            return this.faceSearch != null ? this.faceSearch.toBuilder() : null;
        }

        public final void setFaceSearch(FaceSearchSettings.BuilderImpl faceSearch) {
            this.faceSearch = faceSearch != null ? faceSearch.build() : null;
        }

        @Override
        public final Builder faceSearch(FaceSearchSettings faceSearch) {
            this.faceSearch = faceSearch;
            return this;
        }

        public final ConnectedHomeSettings.Builder getConnectedHome() {
            return this.connectedHome != null ? this.connectedHome.toBuilder() : null;
        }

        public final void setConnectedHome(ConnectedHomeSettings.BuilderImpl connectedHome) {
            this.connectedHome = connectedHome != null ? connectedHome.build() : null;
        }

        @Override
        public final Builder connectedHome(ConnectedHomeSettings connectedHome) {
            this.connectedHome = connectedHome;
            return this;
        }

        public StreamProcessorSettings build() {
            return new StreamProcessorSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamProcessorSettings> {
        public Builder faceSearch(FaceSearchSettings var1);

        default public Builder faceSearch(Consumer<FaceSearchSettings.Builder> faceSearch) {
            return this.faceSearch((FaceSearchSettings)((FaceSearchSettings.Builder)FaceSearchSettings.builder().applyMutation(faceSearch)).build());
        }

        public Builder connectedHome(ConnectedHomeSettings var1);

        default public Builder connectedHome(Consumer<ConnectedHomeSettings.Builder> connectedHome) {
            return this.connectedHome((ConnectedHomeSettings)((ConnectedHomeSettings.Builder)ConnectedHomeSettings.builder().applyMutation(connectedHome)).build());
        }
    }
}

