/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Instance;
import software.amazon.awssdk.services.rekognition.model.InstancesCopier;
import software.amazon.awssdk.services.rekognition.model.LabelAlias;
import software.amazon.awssdk.services.rekognition.model.LabelAliasesCopier;
import software.amazon.awssdk.services.rekognition.model.LabelCategoriesCopier;
import software.amazon.awssdk.services.rekognition.model.LabelCategory;
import software.amazon.awssdk.services.rekognition.model.Parent;
import software.amazon.awssdk.services.rekognition.model.ParentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Label
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Label> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Label.getter(Label::name)).setter(Label.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(Label.getter(Label::confidence)).setter(Label.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(Label.getter(Label::instances)).setter(Label.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Parent>> PARENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parents").getter(Label.getter(Label::parents)).setter(Label.setter(Builder::parents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LabelAlias>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(Label.getter(Label::aliases)).setter(Label.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LabelCategory>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(Label.getter(Label::categories)).setter(Label.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelCategory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIDENCE_FIELD, INSTANCES_FIELD, PARENTS_FIELD, ALIASES_FIELD, CATEGORIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Float confidence;
    private final List<Instance> instances;
    private final List<Parent> parents;
    private final List<LabelAlias> aliases;
    private final List<LabelCategory> categories;

    private Label(BuilderImpl builder) {
        this.name = builder.name;
        this.confidence = builder.confidence;
        this.instances = builder.instances;
        this.parents = builder.parents;
        this.aliases = builder.aliases;
        this.categories = builder.categories;
    }

    public final String name() {
        return this.name;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<Instance> instances() {
        return this.instances;
    }

    public final boolean hasParents() {
        return this.parents != null && !(this.parents instanceof SdkAutoConstructList);
    }

    public final List<Parent> parents() {
        return this.parents;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<LabelAlias> aliases() {
        return this.aliases;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<LabelCategory> categories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParents() ? this.parents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Label)) {
            return false;
        }
        Label other = (Label)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.confidence(), other.confidence()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && this.hasParents() == other.hasParents() && Objects.equals(this.parents(), other.parents()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories());
    }

    public final String toString() {
        return ToString.builder((String)"Label").add("Name", (Object)this.name()).add("Confidence", (Object)this.confidence()).add("Instances", this.hasInstances() ? this.instances() : null).add("Parents", this.hasParents() ? this.parents() : null).add("Aliases", this.hasAliases() ? this.aliases() : null).add("Categories", this.hasCategories() ? this.categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "Parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Label, T> g) {
        return obj -> g.apply((Label)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Float confidence;
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private List<Parent> parents = DefaultSdkAutoConstructList.getInstance();
        private List<LabelAlias> aliases = DefaultSdkAutoConstructList.getInstance();
        private List<LabelCategory> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Label model) {
            this.name(model.name);
            this.confidence(model.confidence);
            this.instances(model.instances);
            this.parents(model.parents);
            this.aliases(model.aliases);
            this.categories(model.categories);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Parent.Builder> getParents() {
            List<Parent.Builder> result = ParentsCopier.copyToBuilder(this.parents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParents(Collection<Parent.BuilderImpl> parents) {
            this.parents = ParentsCopier.copyFromBuilder(parents);
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Consumer<Parent.Builder> ... parents) {
            this.parents(Stream.of(parents).map(c -> (Parent)((Parent.Builder)Parent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LabelAlias.Builder> getAliases() {
            List<LabelAlias.Builder> result = LabelAliasesCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliases(Collection<LabelAlias.BuilderImpl> aliases) {
            this.aliases = LabelAliasesCopier.copyFromBuilder(aliases);
        }

        @Override
        public final Builder aliases(Collection<LabelAlias> aliases) {
            this.aliases = LabelAliasesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(LabelAlias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<LabelAlias.Builder> ... aliases) {
            this.aliases(Stream.of(aliases).map(c -> (LabelAlias)((LabelAlias.Builder)LabelAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LabelCategory.Builder> getCategories() {
            List<LabelCategory.Builder> result = LabelCategoriesCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<LabelCategory.BuilderImpl> categories) {
            this.categories = LabelCategoriesCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<LabelCategory> categories) {
            this.categories = LabelCategoriesCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(LabelCategory ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<LabelCategory.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (LabelCategory)((LabelCategory.Builder)LabelCategory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Label build() {
            return new Label(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Label> {
        public Builder name(String var1);

        public Builder confidence(Float var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder parents(Collection<Parent> var1);

        public Builder parents(Parent ... var1);

        public Builder parents(Consumer<Parent.Builder> ... var1);

        public Builder aliases(Collection<LabelAlias> var1);

        public Builder aliases(LabelAlias ... var1);

        public Builder aliases(Consumer<LabelAlias.Builder> ... var1);

        public Builder categories(Collection<LabelCategory> var1);

        public Builder categories(LabelCategory ... var1);

        public Builder categories(Consumer<LabelCategory.Builder> ... var1);
    }
}

