/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class PortalSsoServiceMetadata implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "portal.sso";

    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder().build();

    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder()
            .put("ap-southeast-1", "portal.sso.ap-southeast-1.amazonaws.com")
            .put("ap-southeast-2", "portal.sso.ap-southeast-2.amazonaws.com")
            .put("ca-central-1", "portal.sso.ca-central-1.amazonaws.com")
            .put("eu-central-1", "portal.sso.eu-central-1.amazonaws.com").put("eu-west-1", "portal.sso.eu-west-1.amazonaws.com")
            .put("eu-west-2", "portal.sso.eu-west-2.amazonaws.com").put("us-east-1", "portal.sso.us-east-1.amazonaws.com")
            .put("us-east-2", "portal.sso.us-east-2.amazonaws.com").put("us-west-2", "portal.sso.us-west-2.amazonaws.com")
            .build();

    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-southeast-1"),
            Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-west-1"),
            Region.of("eu-west-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-2")));

    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.<String, String> builder()
            .put("ap-southeast-1", "ap-southeast-1").put("ap-southeast-2", "ap-southeast-2").put("ca-central-1", "ca-central-1")
            .put("eu-central-1", "eu-central-1").put("eu-west-1", "eu-west-1").put("eu-west-2", "eu-west-2")
            .put("us-east-1", "us-east-1").put("us-east-2", "us-east-2").put("us-west-2", "us-west-2").build();

    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays
            .asList(new DefaultServicePartitionMetadata("aws", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id())
                : computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}
