/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevision;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;

public class DescribeClusterDbRevisionsIterable
implements SdkIterable<DescribeClusterDbRevisionsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterDbRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterDbRevisionsIterable(RedshiftClient client, DescribeClusterDbRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterDbRevisionsResponseFetcher();
    }

    public Iterator<DescribeClusterDbRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterDbRevision> clusterDbRevisions() {
        Function<DescribeClusterDbRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterDbRevisions() != null) {
                return response.clusterDbRevisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClusterDbRevisionsResponseFetcher
    implements SyncPageFetcher<DescribeClusterDbRevisionsResponse> {
        private DescribeClusterDbRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterDbRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeClusterDbRevisionsResponse nextPage(DescribeClusterDbRevisionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterDbRevisionsIterable.this.client.describeClusterDbRevisions(DescribeClusterDbRevisionsIterable.this.firstRequest);
            }
            return DescribeClusterDbRevisionsIterable.this.client.describeClusterDbRevisions((DescribeClusterDbRevisionsRequest)((Object)DescribeClusterDbRevisionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

