/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions;

public class DescribePendingMaintenanceActionsPublisher
implements SdkPublisher<DescribePendingMaintenanceActionsResponse> {
    private final RdsAsyncClient client;
    private final DescribePendingMaintenanceActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePendingMaintenanceActionsPublisher(RdsAsyncClient client, DescribePendingMaintenanceActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePendingMaintenanceActionsPublisher(RdsAsyncClient client, DescribePendingMaintenanceActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePendingMaintenanceActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePendingMaintenanceActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        Function<DescribePendingMaintenanceActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pendingMaintenanceActions() != null) {
                return response.pendingMaintenanceActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePendingMaintenanceActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePendingMaintenanceActionsResponseFetcher
    implements AsyncPageFetcher<DescribePendingMaintenanceActionsResponse> {
        private DescribePendingMaintenanceActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePendingMaintenanceActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribePendingMaintenanceActionsResponse> nextPage(DescribePendingMaintenanceActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribePendingMaintenanceActionsPublisher.this.client.describePendingMaintenanceActions(DescribePendingMaintenanceActionsPublisher.this.firstRequest);
            }
            return DescribePendingMaintenanceActionsPublisher.this.client.describePendingMaintenanceActions((DescribePendingMaintenanceActionsRequest)((Object)DescribePendingMaintenanceActionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

