/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBRecommendation;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse;

public class DescribeDBRecommendationsPublisher
implements SdkPublisher<DescribeDbRecommendationsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBRecommendationsPublisher(RdsAsyncClient client, DescribeDbRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBRecommendationsPublisher(RdsAsyncClient client, DescribeDbRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBRecommendation> dbRecommendations() {
        Function<DescribeDbRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbRecommendations() != null) {
                return response.dbRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbRecommendationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbRecommendationsResponseFetcher
    implements AsyncPageFetcher<DescribeDbRecommendationsResponse> {
        private DescribeDbRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbRecommendationsResponse> nextPage(DescribeDbRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBRecommendationsPublisher.this.client.describeDBRecommendations(DescribeDBRecommendationsPublisher.this.firstRequest);
            }
            return DescribeDBRecommendationsPublisher.this.client.describeDBRecommendations((DescribeDbRecommendationsRequest)((Object)DescribeDBRecommendationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

