/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.RestoreWindow;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterAutomatedBackup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterAutomatedBackup> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::engine)).setter(DBClusterAutomatedBackup.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::vpcId)).setter(DBClusterAutomatedBackup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_AUTOMATED_BACKUPS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterAutomatedBackupsArn").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::dbClusterAutomatedBackupsArn)).setter(DBClusterAutomatedBackup.setter(Builder::dbClusterAutomatedBackupsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterAutomatedBackupsArn").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::dbClusterIdentifier)).setter(DBClusterAutomatedBackup.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<RestoreWindow> RESTORE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestoreWindow").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::restoreWindow)).setter(DBClusterAutomatedBackup.setter(Builder::restoreWindow)).constructor(RestoreWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreWindow").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::masterUsername)).setter(DBClusterAutomatedBackup.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterResourceId").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::dbClusterResourceId)).setter(DBClusterAutomatedBackup.setter(Builder::dbClusterResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::region)).setter(DBClusterAutomatedBackup.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::licenseModel)).setter(DBClusterAutomatedBackup.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::status)).setter(DBClusterAutomatedBackup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IAMDatabaseAuthenticationEnabled").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::iamDatabaseAuthenticationEnabled)).setter(DBClusterAutomatedBackup.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ClusterCreateTime").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::clusterCreateTime)).setter(DBClusterAutomatedBackup.setter(Builder::clusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::storageEncrypted)).setter(DBClusterAutomatedBackup.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::allocatedStorage)).setter(DBClusterAutomatedBackup.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::engineVersion)).setter(DBClusterAutomatedBackup.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterArn").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::dbClusterArn)).setter(DBClusterAutomatedBackup.setter(Builder::dbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::backupRetentionPeriod)).setter(DBClusterAutomatedBackup.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineMode").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::engineMode)).setter(DBClusterAutomatedBackup.setter(Builder::engineMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::availabilityZones)).setter(DBClusterAutomatedBackup.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::port)).setter(DBClusterAutomatedBackup.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::kmsKeyId)).setter(DBClusterAutomatedBackup.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::storageType)).setter(DBClusterAutomatedBackup.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::iops)).setter(DBClusterAutomatedBackup.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> AWS_BACKUP_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsBackupRecoveryPointArn").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::awsBackupRecoveryPointArn)).setter(DBClusterAutomatedBackup.setter(Builder::awsBackupRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupRecoveryPointArn").build()}).build();
    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageThroughput").getter(DBClusterAutomatedBackup.getter(DBClusterAutomatedBackup::storageThroughput)).setter(DBClusterAutomatedBackup.setter(Builder::storageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, VPC_ID_FIELD, DB_CLUSTER_AUTOMATED_BACKUPS_ARN_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, RESTORE_WINDOW_FIELD, MASTER_USERNAME_FIELD, DB_CLUSTER_RESOURCE_ID_FIELD, REGION_FIELD, LICENSE_MODEL_FIELD, STATUS_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, CLUSTER_CREATE_TIME_FIELD, STORAGE_ENCRYPTED_FIELD, ALLOCATED_STORAGE_FIELD, ENGINE_VERSION_FIELD, DB_CLUSTER_ARN_FIELD, BACKUP_RETENTION_PERIOD_FIELD, ENGINE_MODE_FIELD, AVAILABILITY_ZONES_FIELD, PORT_FIELD, KMS_KEY_ID_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD, AWS_BACKUP_RECOVERY_POINT_ARN_FIELD, STORAGE_THROUGHPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Engine", ENGINE_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("DBClusterAutomatedBackupsArn", DB_CLUSTER_AUTOMATED_BACKUPS_ARN_FIELD);
            this.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
            this.put("RestoreWindow", RESTORE_WINDOW_FIELD);
            this.put("MasterUsername", MASTER_USERNAME_FIELD);
            this.put("DbClusterResourceId", DB_CLUSTER_RESOURCE_ID_FIELD);
            this.put("Region", REGION_FIELD);
            this.put("LicenseModel", LICENSE_MODEL_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("IAMDatabaseAuthenticationEnabled", IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD);
            this.put("ClusterCreateTime", CLUSTER_CREATE_TIME_FIELD);
            this.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
            this.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("DBClusterArn", DB_CLUSTER_ARN_FIELD);
            this.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
            this.put("EngineMode", ENGINE_MODE_FIELD);
            this.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("StorageType", STORAGE_TYPE_FIELD);
            this.put("Iops", IOPS_FIELD);
            this.put("AwsBackupRecoveryPointArn", AWS_BACKUP_RECOVERY_POINT_ARN_FIELD);
            this.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String vpcId;
    private final String dbClusterAutomatedBackupsArn;
    private final String dbClusterIdentifier;
    private final RestoreWindow restoreWindow;
    private final String masterUsername;
    private final String dbClusterResourceId;
    private final String region;
    private final String licenseModel;
    private final String status;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final Instant clusterCreateTime;
    private final Boolean storageEncrypted;
    private final Integer allocatedStorage;
    private final String engineVersion;
    private final String dbClusterArn;
    private final Integer backupRetentionPeriod;
    private final String engineMode;
    private final List<String> availabilityZones;
    private final Integer port;
    private final String kmsKeyId;
    private final String storageType;
    private final Integer iops;
    private final String awsBackupRecoveryPointArn;
    private final Integer storageThroughput;

    private DBClusterAutomatedBackup(BuilderImpl builder) {
        this.engine = builder.engine;
        this.vpcId = builder.vpcId;
        this.dbClusterAutomatedBackupsArn = builder.dbClusterAutomatedBackupsArn;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreWindow = builder.restoreWindow;
        this.masterUsername = builder.masterUsername;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.region = builder.region;
        this.licenseModel = builder.licenseModel;
        this.status = builder.status;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.storageEncrypted = builder.storageEncrypted;
        this.allocatedStorage = builder.allocatedStorage;
        this.engineVersion = builder.engineVersion;
        this.dbClusterArn = builder.dbClusterArn;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.engineMode = builder.engineMode;
        this.availabilityZones = builder.availabilityZones;
        this.port = builder.port;
        this.kmsKeyId = builder.kmsKeyId;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.awsBackupRecoveryPointArn = builder.awsBackupRecoveryPointArn;
        this.storageThroughput = builder.storageThroughput;
    }

    public final String engine() {
        return this.engine;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String dbClusterAutomatedBackupsArn() {
        return this.dbClusterAutomatedBackupsArn;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final RestoreWindow restoreWindow() {
        return this.restoreWindow;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String dbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public final String region() {
        return this.region;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public final Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String dbClusterArn() {
        return this.dbClusterArn;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String engineMode() {
        return this.engineMode;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Integer port() {
        return this.port;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String awsBackupRecoveryPointArn() {
        return this.awsBackupRecoveryPointArn;
    }

    public final Integer storageThroughput() {
        return this.storageThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterAutomatedBackupsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsBackupRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageThroughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterAutomatedBackup)) {
            return false;
        }
        DBClusterAutomatedBackup other = (DBClusterAutomatedBackup)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.dbClusterAutomatedBackupsArn(), other.dbClusterAutomatedBackupsArn()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.restoreWindow(), other.restoreWindow()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.dbClusterResourceId(), other.dbClusterResourceId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbClusterArn(), other.dbClusterArn()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.engineMode(), other.engineMode()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.awsBackupRecoveryPointArn(), other.awsBackupRecoveryPointArn()) && Objects.equals(this.storageThroughput(), other.storageThroughput());
    }

    public final String toString() {
        return ToString.builder((String)"DBClusterAutomatedBackup").add("Engine", (Object)this.engine()).add("VpcId", (Object)this.vpcId()).add("DBClusterAutomatedBackupsArn", (Object)this.dbClusterAutomatedBackupsArn()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("RestoreWindow", (Object)this.restoreWindow()).add("MasterUsername", (Object)this.masterUsername()).add("DbClusterResourceId", (Object)this.dbClusterResourceId()).add("Region", (Object)this.region()).add("LicenseModel", (Object)this.licenseModel()).add("Status", (Object)this.status()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("EngineVersion", (Object)this.engineVersion()).add("DBClusterArn", (Object)this.dbClusterArn()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("EngineMode", (Object)this.engineMode()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("Port", (Object)this.port()).add("KmsKeyId", (Object)this.kmsKeyId()).add("StorageType", (Object)this.storageType()).add("Iops", (Object)this.iops()).add("AwsBackupRecoveryPointArn", (Object)this.awsBackupRecoveryPointArn()).add("StorageThroughput", (Object)this.storageThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "DBClusterAutomatedBackupsArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterAutomatedBackupsArn()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "RestoreWindow": {
                return Optional.ofNullable(clazz.cast(this.restoreWindow()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DbClusterResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterResourceId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBClusterArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterArn()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "AwsBackupRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.awsBackupRecoveryPointArn()));
            }
            case "StorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.storageThroughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterAutomatedBackup, T> g) {
        return obj -> g.apply((DBClusterAutomatedBackup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String vpcId;
        private String dbClusterAutomatedBackupsArn;
        private String dbClusterIdentifier;
        private RestoreWindow restoreWindow;
        private String masterUsername;
        private String dbClusterResourceId;
        private String region;
        private String licenseModel;
        private String status;
        private Boolean iamDatabaseAuthenticationEnabled;
        private Instant clusterCreateTime;
        private Boolean storageEncrypted;
        private Integer allocatedStorage;
        private String engineVersion;
        private String dbClusterArn;
        private Integer backupRetentionPeriod;
        private String engineMode;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer port;
        private String kmsKeyId;
        private String storageType;
        private Integer iops;
        private String awsBackupRecoveryPointArn;
        private Integer storageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterAutomatedBackup model) {
            this.engine(model.engine);
            this.vpcId(model.vpcId);
            this.dbClusterAutomatedBackupsArn(model.dbClusterAutomatedBackupsArn);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.restoreWindow(model.restoreWindow);
            this.masterUsername(model.masterUsername);
            this.dbClusterResourceId(model.dbClusterResourceId);
            this.region(model.region);
            this.licenseModel(model.licenseModel);
            this.status(model.status);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.clusterCreateTime(model.clusterCreateTime);
            this.storageEncrypted(model.storageEncrypted);
            this.allocatedStorage(model.allocatedStorage);
            this.engineVersion(model.engineVersion);
            this.dbClusterArn(model.dbClusterArn);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.engineMode(model.engineMode);
            this.availabilityZones(model.availabilityZones);
            this.port(model.port);
            this.kmsKeyId(model.kmsKeyId);
            this.storageType(model.storageType);
            this.iops(model.iops);
            this.awsBackupRecoveryPointArn(model.awsBackupRecoveryPointArn);
            this.storageThroughput(model.storageThroughput);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getDbClusterAutomatedBackupsArn() {
            return this.dbClusterAutomatedBackupsArn;
        }

        public final void setDbClusterAutomatedBackupsArn(String dbClusterAutomatedBackupsArn) {
            this.dbClusterAutomatedBackupsArn = dbClusterAutomatedBackupsArn;
        }

        @Override
        public final Builder dbClusterAutomatedBackupsArn(String dbClusterAutomatedBackupsArn) {
            this.dbClusterAutomatedBackupsArn = dbClusterAutomatedBackupsArn;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final RestoreWindow.Builder getRestoreWindow() {
            return this.restoreWindow != null ? this.restoreWindow.toBuilder() : null;
        }

        public final void setRestoreWindow(RestoreWindow.BuilderImpl restoreWindow) {
            this.restoreWindow = restoreWindow != null ? restoreWindow.build() : null;
        }

        @Override
        public final Builder restoreWindow(RestoreWindow restoreWindow) {
            this.restoreWindow = restoreWindow;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getDbClusterResourceId() {
            return this.dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbClusterArn() {
            return this.dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getAwsBackupRecoveryPointArn() {
            return this.awsBackupRecoveryPointArn;
        }

        public final void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
        }

        @Override
        public final Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
            return this;
        }

        public final Integer getStorageThroughput() {
            return this.storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public DBClusterAutomatedBackup build() {
            return new DBClusterAutomatedBackup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterAutomatedBackup> {
        public Builder engine(String var1);

        public Builder vpcId(String var1);

        public Builder dbClusterAutomatedBackupsArn(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder restoreWindow(RestoreWindow var1);

        default public Builder restoreWindow(Consumer<RestoreWindow.Builder> restoreWindow) {
            return this.restoreWindow((RestoreWindow)((RestoreWindow.Builder)RestoreWindow.builder().applyMutation(restoreWindow)).build());
        }

        public Builder masterUsername(String var1);

        public Builder dbClusterResourceId(String var1);

        public Builder region(String var1);

        public Builder licenseModel(String var1);

        public Builder status(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder allocatedStorage(Integer var1);

        public Builder engineVersion(String var1);

        public Builder dbClusterArn(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder engineMode(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder port(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder storageType(String var1);

        public Builder iops(Integer var1);

        public Builder awsBackupRecoveryPointArn(String var1);

        public Builder storageThroughput(Integer var1);
    }
}

