/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbProxyEndpointRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbProxyEndpointRequest> {
    private static final SdkField<String> DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyEndpointName").getter(ModifyDbProxyEndpointRequest.getter(ModifyDbProxyEndpointRequest::dbProxyEndpointName)).setter(ModifyDbProxyEndpointRequest.setter(Builder::dbProxyEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpointName").build()}).build();
    private static final SdkField<String> NEW_DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewDBProxyEndpointName").getter(ModifyDbProxyEndpointRequest.getter(ModifyDbProxyEndpointRequest::newDBProxyEndpointName)).setter(ModifyDbProxyEndpointRequest.setter(Builder::newDBProxyEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBProxyEndpointName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(ModifyDbProxyEndpointRequest.getter(ModifyDbProxyEndpointRequest::vpcSecurityGroupIds)).setter(ModifyDbProxyEndpointRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_ENDPOINT_NAME_FIELD, NEW_DB_PROXY_ENDPOINT_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));
    private final String dbProxyEndpointName;
    private final String newDBProxyEndpointName;
    private final List<String> vpcSecurityGroupIds;

    private ModifyDbProxyEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyEndpointName = builder.dbProxyEndpointName;
        this.newDBProxyEndpointName = builder.newDBProxyEndpointName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    public final String dbProxyEndpointName() {
        return this.dbProxyEndpointName;
    }

    public final String newDBProxyEndpointName() {
        return this.newDBProxyEndpointName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDBProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyEndpointRequest)) {
            return false;
        }
        ModifyDbProxyEndpointRequest other = (ModifyDbProxyEndpointRequest)((Object)obj);
        return Objects.equals(this.dbProxyEndpointName(), other.dbProxyEndpointName()) && Objects.equals(this.newDBProxyEndpointName(), other.newDBProxyEndpointName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbProxyEndpointRequest").add("DBProxyEndpointName", (Object)this.dbProxyEndpointName()).add("NewDBProxyEndpointName", (Object)this.newDBProxyEndpointName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyEndpointName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyEndpointName()));
            }
            case "NewDBProxyEndpointName": {
                return Optional.ofNullable(clazz.cast(this.newDBProxyEndpointName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyEndpointRequest, T> g) {
        return obj -> g.apply((ModifyDbProxyEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbProxyEndpointName;
        private String newDBProxyEndpointName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyEndpointRequest model) {
            super(model);
            this.dbProxyEndpointName(model.dbProxyEndpointName);
            this.newDBProxyEndpointName(model.newDBProxyEndpointName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getDbProxyEndpointName() {
            return this.dbProxyEndpointName;
        }

        public final void setDbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
        }

        @Override
        public final Builder dbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        public final String getNewDBProxyEndpointName() {
            return this.newDBProxyEndpointName;
        }

        public final void setNewDBProxyEndpointName(String newDBProxyEndpointName) {
            this.newDBProxyEndpointName = newDBProxyEndpointName;
        }

        @Override
        public final Builder newDBProxyEndpointName(String newDBProxyEndpointName) {
            this.newDBProxyEndpointName = newDBProxyEndpointName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbProxyEndpointRequest build() {
            return new ModifyDbProxyEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbProxyEndpointRequest> {
        public Builder dbProxyEndpointName(String var1);

        public Builder newDBProxyEndpointName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

