/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbClusterRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbClusterRequest.Builder, CreateDbClusterRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(CreateDbClusterRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(CreateDbClusterRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(CreateDbClusterRequest::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateDbClusterRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(CreateDbClusterRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(CreateDbClusterRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(CreateDbClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(CreateDbClusterRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateDbClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateDbClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateDbClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(CreateDbClusterRequest::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(CreateDbClusterRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(CreateDbClusterRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(CreateDbClusterRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CreateDbClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> REPLICATION_SOURCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSourceIdentifier")
            .getter(getter(CreateDbClusterRequest::replicationSourceIdentifier))
            .setter(setter(Builder::replicationSourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSourceIdentifier")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(CreateDbClusterRequest::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateDbClusterRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSignedUrl").getter(getter(CreateDbClusterRequest::preSignedUrl))
            .setter(setter(Builder::preSignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(CreateDbClusterRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BacktrackWindow").getter(getter(CreateDbClusterRequest::backtrackWindow))
            .setter(setter(Builder::backtrackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(CreateDbClusterRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineMode").getter(getter(CreateDbClusterRequest::engineMode)).setter(setter(Builder::engineMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()).build();

    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScalingConfiguration")
            .getter(getter(CreateDbClusterRequest::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(CreateDbClusterRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(CreateDbClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> ENABLE_HTTP_ENDPOINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableHttpEndpoint").getter(getter(CreateDbClusterRequest::enableHttpEndpoint))
            .setter(setter(Builder::enableHttpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHttpEndpoint").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(CreateDbClusterRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(CreateDbClusterRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(CreateDbClusterRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<Boolean> ENABLE_GLOBAL_WRITE_FORWARDING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableGlobalWriteForwarding")
            .getter(getter(CreateDbClusterRequest::enableGlobalWriteForwarding))
            .setter(setter(Builder::enableGlobalWriteForwarding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableGlobalWriteForwarding")
                    .build()).build();

    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterInstanceClass").getter(getter(CreateDbClusterRequest::dbClusterInstanceClass))
            .setter(setter(Builder::dbClusterInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(CreateDbClusterRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(CreateDbClusterRequest::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(CreateDbClusterRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(CreateDbClusterRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateDbClusterRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(CreateDbClusterRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(CreateDbClusterRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(CreateDbClusterRequest::enablePerformanceInsights)).setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(CreateDbClusterRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(CreateDbClusterRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField
            .<ServerlessV2ScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerlessV2ScalingConfiguration")
            .getter(getter(CreateDbClusterRequest::serverlessV2ScalingConfiguration))
            .setter(setter(Builder::serverlessV2ScalingConfiguration))
            .constructor(ServerlessV2ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration")
                    .build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(CreateDbClusterRequest::networkType)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<String> DB_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSystemId").getter(getter(CreateDbClusterRequest::dbSystemId)).setter(setter(Builder::dbSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSystemId").build()).build();

    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword")
            .getter(getter(CreateDbClusterRequest::manageMasterUserPassword)).setter(setter(Builder::manageMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build())
            .build();

    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserSecretKmsKeyId").getter(getter(CreateDbClusterRequest::masterUserSecretKmsKeyId))
            .setter(setter(Builder::masterUserSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build())
            .build();

    private static final SdkField<Boolean> ENABLE_LOCAL_WRITE_FORWARDING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableLocalWriteForwarding")
            .getter(getter(CreateDbClusterRequest::enableLocalWriteForwarding))
            .setter(setter(Builder::enableLocalWriteForwarding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLocalWriteForwarding").build())
            .build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(CreateDbClusterRequest::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD, DB_CLUSTER_IDENTIFIER_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, OPTION_GROUP_NAME_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SOURCE_IDENTIFIER_FIELD, TAGS_FIELD,
            STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD,
            BACKTRACK_WINDOW_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, ENGINE_MODE_FIELD, SCALING_CONFIGURATION_FIELD,
            DELETION_PROTECTION_FIELD, GLOBAL_CLUSTER_IDENTIFIER_FIELD, ENABLE_HTTP_ENDPOINT_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD,
            DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, ENABLE_GLOBAL_WRITE_FORWARDING_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD,
            ALLOCATED_STORAGE_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD,
            MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD,
            PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD,
            SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, NETWORK_TYPE_FIELD, DB_SYSTEM_ID_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD,
            MASTER_USER_SECRET_KMS_KEY_ID_FIELD, ENABLE_LOCAL_WRITE_FORWARDING_FIELD, SOURCE_REGION_FIELD));

    private final List<String> availabilityZones;

    private final Integer backupRetentionPeriod;

    private final String characterSetName;

    private final String databaseName;

    private final String dbClusterIdentifier;

    private final String dbClusterParameterGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final String dbSubnetGroupName;

    private final String engine;

    private final String engineVersion;

    private final Integer port;

    private final String masterUsername;

    private final String masterUserPassword;

    private final String optionGroupName;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final String replicationSourceIdentifier;

    private final List<Tag> tags;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String preSignedUrl;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Long backtrackWindow;

    private final List<String> enableCloudwatchLogsExports;

    private final String engineMode;

    private final ScalingConfiguration scalingConfiguration;

    private final Boolean deletionProtection;

    private final String globalClusterIdentifier;

    private final Boolean enableHttpEndpoint;

    private final Boolean copyTagsToSnapshot;

    private final String domain;

    private final String domainIAMRoleName;

    private final Boolean enableGlobalWriteForwarding;

    private final String dbClusterInstanceClass;

    private final Integer allocatedStorage;

    private final String storageType;

    private final Integer iops;

    private final Boolean publiclyAccessible;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

    private final String networkType;

    private final String dbSystemId;

    private final Boolean manageMasterUserPassword;

    private final String masterUserSecretKmsKeyId;

    private final Boolean enableLocalWriteForwarding;

    private final String sourceRegion;

    private CreateDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.tags = builder.tags;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.engineMode = builder.engineMode;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.deletionProtection = builder.deletionProtection;
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.enableHttpEndpoint = builder.enableHttpEndpoint;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.enableGlobalWriteForwarding = builder.enableGlobalWriteForwarding;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.networkType = builder.networkType;
        this.dbSystemId = builder.dbSystemId;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.enableLocalWriteForwarding = builder.enableLocalWriteForwarding;
        this.sourceRegion = builder.sourceRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
     * </p>
     * <p>
     * For information on Amazon Web Services Regions and Availability Zones, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html"
     * >Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
     *         <p>
     *         For information on Amazon Web Services Regions and Availability Zones, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html"
     *         >Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 1 to 35.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups are retained.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Default: <code>1</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 1 to 35.
     *         </p>
     *         </li>
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The name of the character set (<code>CharacterSet</code>) to associate the DB cluster with.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The name of the character set (<code>CharacterSet</code>) to associate the DB cluster with.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The name for your database of up to 64 alphanumeric characters. If you don't provide a name, Amazon RDS doesn't
     * create a database in the DB cluster you are creating.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name for your database of up to 64 alphanumeric characters. If you don't provide a name, Amazon RDS
     *         doesn't create a database in the DB cluster you are creating.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The identifier for this DB cluster. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     * </p>
     * 
     * @return The identifier for this DB cluster. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster1</code>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with this DB cluster. If you don't specify a value, then
     * the default DB cluster parameter group for the specified DB engine and version is used.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DB cluster parameter group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB cluster parameter group to associate with this DB cluster. If you don't specify a
     *         value, then the default DB cluster parameter group for the specified DB engine and version is used.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DB cluster parameter group.
     *         </p>
     *         </li>
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with this DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * A DB subnet group to associate with this DB cluster.
     * </p>
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the name of an existing DB subnet group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not be <code>default</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * 
     * @return A DB subnet group to associate with this DB cluster.</p>
     *         <p>
     *         This setting is required to create a Multi-AZ DB cluster.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the name of an existing DB subnet group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not be <code>default</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The database engine to use for this DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Valid Values: <code>aurora-mysql | aurora-postgresql | mysql | postgres</code>
     * </p>
     * 
     * @return The database engine to use for this DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Valid Values: <code>aurora-mysql | aurora-postgresql | mysql | postgres</code>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the database engine to use.
     * </p>
     * <p>
     * To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (MySQL
     * 8.0-compatible), use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for Aurora MySQL
     * version 2 or version 3, respectively.
     * </p>
     * <p>
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * For information about a specific engine, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora MySQL - see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database engine
     * updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora PostgreSQL - see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon
     * Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">Amazon
     * RDS for MySQL</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS
     * for PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The version number of the database engine to use.</p>
     *         <p>
     *         To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3
     *         (MySQL 8.0-compatible), use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for Aurora
     *         MySQL version 2 or version 3, respectively.
     *         </p>
     *         <p>
     *         To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for RDS for MySQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         For information about a specific engine, see the following topics:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora MySQL - see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database
     *         engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL - see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html"
     *         >Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
     *         >Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
     *         >Amazon RDS for PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The port number on which the instances in the DB cluster accept connections.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Valid Values: <code>1150-65535</code>
     * </p>
     * <p>
     * Default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RDS for MySQL and Aurora MySQL - <code>3306</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL and Aurora PostgreSQL - <code>5432</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The port number on which the instances in the DB cluster accept connections.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Valid Values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         RDS for MySQL and Aurora MySQL - <code>3306</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL and Aurora PostgreSQL - <code>5432</code>
     *         </p>
     *         </li>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the master user for the DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 16 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the master user for the DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master database user.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 8 to 41 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can contain any printable ASCII character except "/", """, or "@".
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The password for the master database user.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 8 to 41 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can contain any printable ASCII character except "/", """, or "@".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The option group to associate the DB cluster with.
     * </p>
     * <p>
     * DB clusters are associated with a default option group that can't be modified.
     * </p>
     * 
     * @return The option group to associate the DB cluster with.</p>
     *         <p>
     *         DB clusters are associated with a default option group that can't be modified.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled using the
     * <code>BackupRetentionPeriod</code> parameter.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region. To view the time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
     * > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled using
     *         the <code>BackupRetentionPeriod</code> parameter.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region. To view the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
     *         > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region, occurring on a random day of the week. To see the time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The weekly time range during which system maintenance can occur.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region, occurring on a random day of the week. To see the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     *         > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read
     * replica.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a
     *         read replica.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String replicationSourceIdentifier() {
        return replicationSourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to assign to the DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether the DB cluster is encrypted.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether the DB cluster is encrypted.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * When a KMS key isn't specified in <code>KmsKeyId</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS uses the KMS key used
     * to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't
     * specified, then Amazon RDS uses your default KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make sure to set
     * <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This
     * KMS key is used to encrypt the read replica in that Amazon Web Services Region.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         When a KMS key isn't specified in <code>KmsKeyId</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS uses the KMS
     *         key used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code>
     *         isn't specified, then Amazon RDS uses your default KMS key.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make sure
     *         to set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services
     *         Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an URL that
     * contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> operation to be called in the
     * source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only
     * when you are performing cross-Region replication from an encrypted DB cluster.
     * </p>
     * <p>
     * The presigned URL must be a valid request for the <code>CreateDBCluster</code> API operation that can run in the
     * source Amazon Web Services Region that contains the encrypted DB cluster to copy.
     * </p>
     * <p>
     * The presigned URL request must contain the following parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in
     * the destination Amazon Web Services Region. This should refer to the same KMS key for both the
     * <code>CreateDBCluster</code> operation that is called in the destination Amazon Web Services Region, and the
     * operation contained in the presigned URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be
     * created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied.
     * This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For
     * example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your
     * <code>ReplicationSourceIdentifier</code> would look like Example:
     * <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn how to generate a Signature Version 4 signed request, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests:
     * Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing
     * Process</a>.
     * </p>
     * <note>
     * <p>
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or
     * <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying
     * <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in
     * the source Amazon Web Services Region.
     * </p>
     * </note>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an
     *         URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> operation to
     *         be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify
     *         <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB
     *         cluster.</p>
     *         <p>
     *         The presigned URL must be a valid request for the <code>CreateDBCluster</code> API operation that can run
     *         in the source Amazon Web Services Region that contains the encrypted DB cluster to copy.
     *         </p>
     *         <p>
     *         The presigned URL request must contain the following parameter values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB
     *         cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the
     *         <code>CreateDBCluster</code> operation that is called in the destination Amazon Web Services Region, and
     *         the operation contained in the presigned URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will
     *         be created in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be
     *         copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web
     *         Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web
     *         Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example:
     *         <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To learn how to generate a Signature Version 4 signed request, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating
     *         Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4
     *         Signing Process</a>.
     *         </p>
     *         <note>
     *         <p>
     *         If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code>
     *         (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually.
     *         Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the
     *         operation that can run in the source Amazon Web Services Region.
     *         </p>
     *         </note>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String preSignedUrl() {
        return preSignedUrl;
    }

    /**
     * <p>
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts
     *         to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
     *         Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora MySQL DB clusters only
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora MySQL DB clusters only
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *         </p>
     *         </li>
     */
    public final Long backtrackWindow() {
        return backtrackWindow;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * The following values are valid for each DB engine:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora MySQL - <code>audit | error | general | slowquery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora PostgreSQL - <code>postgresql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - <code>error | general | slowquery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - <code>postgresql | upgrade</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         The following values are valid for each DB engine:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora MySQL - <code>audit | error | general | slowquery</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL - <code>postgresql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - <code>error | general | slowquery</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - <code>postgresql | upgrade</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.
     * </p>
     * <p>
     * The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters.
     * </p>
     * <p>
     * For information about limitations and requirements for Serverless DB clusters, see the following sections in the
     * <i>Amazon Aurora User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"
     * >Limitations of Aurora Serverless v1</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html">
     * Requirements for Aurora Serverless v2</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p>
     *         <p>
     *         The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters.
     *         </p>
     *         <p>
     *         For information about limitations and requirements for Serverless DB clusters, see the following sections
     *         in the <i>Amazon Aurora User Guide</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"
     *         >Limitations of Aurora Serverless v1</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html"
     *         >Requirements for Aurora Serverless v2</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String engineMode() {
        return engineMode;
    }

    /**
     * <p>
     * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final ScalingConfiguration scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion
     * protection is enabled. By default, deletion protection isn't enabled.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when
     *         deletion protection is enabled. By default, deletion protection isn't enabled.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database
     *         cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP
     * endpoint is disabled.
     * </p>
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora
     * Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora
     * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the
     *         HTTP endpoint is disabled.</p>
     *         <p>
     *         When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the
     *         Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the
     *         query editor.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for
     *         Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final Boolean enableHttpEndpoint() {
        return enableHttpEndpoint;
    }

    /**
     * <p>
     * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy
     * them.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not
     *         to copy them.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The Active Directory directory ID to create the DB cluster in.
     * </p>
     * <p>
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to
     * the DB cluster.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     * authentication</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The Active Directory directory ID to create the DB cluster in.</p>
     *         <p>
     *         For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that
     *         connect to the DB cluster.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     *         authentication</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the IAM role to use when making API calls to the Directory Service.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The name of the IAM role to use when making API calls to the Directory Service.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global
     * cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are
     * secondary clusters in an Aurora global database.
     * </p>
     * <p>
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this
     * parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting
     * changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value
     * is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a
     *         global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB
     *         clusters that are secondary clusters in an Aurora global database.</p>
     *         <p>
     *         You can set this value only on Aurora DB clusters that are members of an Aurora global database. With
     *         this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the
     *         resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global
     *         database, this value is used immediately if the primary is demoted by a global cluster API operation, but
     *         it does nothing until then.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final Boolean enableGlobalWriteForwarding() {
        return enableGlobalWriteForwarding;
    }

    /**
     * <p>
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
     * <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for
     * all database engines.
     * </p>
     * <p>
     * For the full list of DB instance classes and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a>
     * in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
     *         <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services
     *         Regions, or for all database engines.</p>
     *         <p>
     *         For the full list of DB instance classes and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
     *         class</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting is required to create a Multi-AZ DB cluster.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final String dbClusterInstanceClass() {
        return dbClusterInstanceClass;
    }

    /**
     * <p>
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * </p>
     * 
     * @return The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         This setting is required to create a Multi-AZ DB cluster.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The storage type to associate with the DB cluster.
     * </p>
     * <p>
     * For information on storage types for Aurora DB clusters, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
     * >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ DB
     * clusters, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
     * >Settings for creating Multi-AZ DB clusters</a>.
     * </p>
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * </p>
     * <p>
     * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora DB clusters - <code>aurora | aurora-iopt1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-AZ DB clusters - <code>io1</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora DB clusters - <code>aurora</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-AZ DB clusters - <code>io1</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code>, the storage type is
     * returned in the response. The storage type isn't returned when you set it to <code>aurora</code>.
     * </p>
     * </note>
     * 
     * @return The storage type to associate with the DB cluster.</p>
     *         <p>
     *         For information on storage types for Aurora DB clusters, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
     *         >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ
     *         DB clusters, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
     *         >Settings for creating Multi-AZ DB clusters</a>.
     *         </p>
     *         <p>
     *         This setting is required to create a Multi-AZ DB cluster.
     *         </p>
     *         <p>
     *         When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora DB clusters - <code>aurora | aurora-iopt1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Multi-AZ DB clusters - <code>io1</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora DB clusters - <code>aurora</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Multi-AZ DB clusters - <code>io1</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code>, the storage
     *         type is returned in the response. The storage type isn't returned when you set it to <code>aurora</code>.
     *         </p>
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     * instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * For information about valid IOPS values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned IOPS
     * storage</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     *         instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         For information about valid IOPS values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned
     *         IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting is required to create a Multi-AZ DB cluster.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     *         </p>
     *         </li>
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Specifies whether the DB cluster is publicly accessible.
     * </p>
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses.
     * That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * </p>
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * </p>
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether the DB cluster is publicly accessible.</p>
     *         <p>
     *         When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
     *         IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address
     *         from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security
     *         group it uses. That public access isn't permitted if the security group assigned to the DB cluster
     *         doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves
     *         to a private IP address.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     *         </p>
     *         <p>
     *         If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified,
     *         the following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster
     *         is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     *         following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is
     *         private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *         </p>
     *         </li>
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance
     * window. By default, minor engine upgrades are applied automatically.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return Specifies whether minor engine upgrades are applied automatically to the DB cluster during the
     *         maintenance window. By default, minor engine upgrades are applied automatically.</p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To
     * turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than
     * <code>0</code>.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other
     *         than <code>0</code>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon
     * CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     * monitoring role, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     * >Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to
     *         Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For
     *         information on creating a monitoring role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     *         >Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
     *         <code>MonitoringRoleArn</code> value.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * Specifies whether to turn on Performance Insights for the DB cluster.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance
     * Insights</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return Specifies whether to turn on Performance Insights for the DB cluster.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon
     *         Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31),
     * <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>731</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * </p>
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data.</p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
     *         months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>731</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>7</code> days
     *         </p>
     *         <p>
     *         If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * Returns the value of the ServerlessV2ScalingConfiguration property for this object.
     * 
     * @return The value of the ServerlessV2ScalingConfiguration property for this object.
     */
    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return serverlessV2ScalingConfiguration;
    }

    /**
     * <p>
     * The network type of the DB cluster.
     * </p>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     * Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * <p>
     * Valid Values: <code>IPV4 | DUAL</code>
     * </p>
     * 
     * @return The network type of the DB cluster.</p>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"
     *         > Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     *         </p>
     *         <p>
     *         Valid Values: <code>IPV4 | DUAL</code>
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String dbSystemId() {
        return dbSystemId;
    }

    /**
     * <p>
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
     * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management
     * with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code>
     * is specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't manage the master user password with Amazon Web Services Secrets Manager if
     *         <code>MasterUserPassword</code> is specified.
     *         </p>
     *         </li>
     */
    public final Boolean manageMasterUserPassword() {
        return manageMasterUserPassword;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
     * Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager
     * for the DB cluster.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is
     * used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the
     * <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.
     * </p>
     * <p>
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
     *         managed in Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
     *         Manager for the DB cluster.
     *         </p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS
     *         key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you
     *         can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer
     *         managed KMS key.
     *         </p>
     *         <p>
     *         There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String masterUserSecretKmsKeyId() {
        return masterUserSecretKmsKeyId;
    }

    /**
     * <p>
     * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By
     * default, write operations aren't allowed on reader DB instances.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster.
     *         By default, write operations aren't allowed on reader DB instances.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final Boolean enableLocalWriteForwarding() {
        return enableLocalWriteForwarding;
    }

    /**
     * If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl will be
     * generated automatically by the SDK.
     * 
     * @return If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl
     *         will be generated automatically by the SDK.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(enableHttpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(enableGlobalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(dbSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableLocalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbClusterRequest)) {
            return false;
        }
        CreateDbClusterRequest other = (CreateDbClusterRequest) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(replicationSourceIdentifier(), other.replicationSourceIdentifier())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(preSignedUrl(), other.preSignedUrl())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(backtrackWindow(), other.backtrackWindow())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(engineMode(), other.engineMode())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(enableHttpEndpoint(), other.enableHttpEndpoint())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(domain(), other.domain())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(enableGlobalWriteForwarding(), other.enableGlobalWriteForwarding())
                && Objects.equals(dbClusterInstanceClass(), other.dbClusterInstanceClass())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(storageType(), other.storageType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && Objects.equals(serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration())
                && Objects.equals(networkType(), other.networkType()) && Objects.equals(dbSystemId(), other.dbSystemId())
                && Objects.equals(manageMasterUserPassword(), other.manageMasterUserPassword())
                && Objects.equals(masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId())
                && Objects.equals(enableLocalWriteForwarding(), other.enableLocalWriteForwarding())
                && Objects.equals(sourceRegion(), other.sourceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbClusterRequest")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BackupRetentionPeriod", backupRetentionPeriod()).add("CharacterSetName", characterSetName())
                .add("DatabaseName", databaseName()).add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("DBSubnetGroupName", dbSubnetGroupName()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("Port", port()).add("MasterUsername", masterUsername()).add("MasterUserPassword", masterUserPassword())
                .add("OptionGroupName", optionGroupName()).add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("ReplicationSourceIdentifier", replicationSourceIdentifier()).add("Tags", hasTags() ? tags() : null)
                .add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId()).add("PreSignedUrl", preSignedUrl())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("BacktrackWindow", backtrackWindow())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("EngineMode", engineMode()).add("ScalingConfiguration", scalingConfiguration())
                .add("DeletionProtection", deletionProtection()).add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("EnableHttpEndpoint", enableHttpEndpoint()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("Domain", domain()).add("DomainIAMRoleName", domainIAMRoleName())
                .add("EnableGlobalWriteForwarding", enableGlobalWriteForwarding())
                .add("DBClusterInstanceClass", dbClusterInstanceClass()).add("AllocatedStorage", allocatedStorage())
                .add("StorageType", storageType()).add("Iops", iops()).add("PubliclyAccessible", publiclyAccessible())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("MonitoringInterval", monitoringInterval())
                .add("MonitoringRoleArn", monitoringRoleArn()).add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("ServerlessV2ScalingConfiguration", serverlessV2ScalingConfiguration()).add("NetworkType", networkType())
                .add("DBSystemId", dbSystemId()).add("ManageMasterUserPassword", manageMasterUserPassword())
                .add("MasterUserSecretKmsKeyId", masterUserSecretKmsKeyId())
                .add("EnableLocalWriteForwarding", enableLocalWriteForwarding()).add("SourceRegion", sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "ReplicationSourceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSourceIdentifier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "BacktrackWindow":
            return Optional.ofNullable(clazz.cast(backtrackWindow()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "EngineMode":
            return Optional.ofNullable(clazz.cast(engineMode()));
        case "ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "EnableHttpEndpoint":
            return Optional.ofNullable(clazz.cast(enableHttpEndpoint()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "EnableGlobalWriteForwarding":
            return Optional.ofNullable(clazz.cast(enableGlobalWriteForwarding()));
        case "DBClusterInstanceClass":
            return Optional.ofNullable(clazz.cast(dbClusterInstanceClass()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "ServerlessV2ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessV2ScalingConfiguration()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "DBSystemId":
            return Optional.ofNullable(clazz.cast(dbSystemId()));
        case "ManageMasterUserPassword":
            return Optional.ofNullable(clazz.cast(manageMasterUserPassword()));
        case "MasterUserSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterUserSecretKmsKeyId()));
        case "EnableLocalWriteForwarding":
            return Optional.ofNullable(clazz.cast(enableLocalWriteForwarding()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbClusterRequest, T> g) {
        return obj -> g.apply((CreateDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbClusterRequest> {
        /**
         * <p>
         * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
         * </p>
         * <p>
         * For information on Amazon Web Services Regions and Availability Zones, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
         *        <p>
         *        For information on Amazon Web Services Regions and Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
         * </p>
         * <p>
         * For information on Amazon Web Services Regions and Availability Zones, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
         *        <p>
         *        For information on Amazon Web Services Regions and Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The number of days for which automated backups are retained.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 1 to 35.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Default: <code>1</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 1 to 35.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The name of the character set (<code>CharacterSet</code>) to associate the DB cluster with.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param characterSetName
         *        The name of the character set (<code>CharacterSet</code>) to associate the DB cluster with.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The name for your database of up to 64 alphanumeric characters. If you don't provide a name, Amazon RDS
         * doesn't create a database in the DB cluster you are creating.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param databaseName
         *        The name for your database of up to 64 alphanumeric characters. If you don't provide a name, Amazon
         *        RDS doesn't create a database in the DB cluster you are creating.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The identifier for this DB cluster. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster1</code>
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The identifier for this DB cluster. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with this DB cluster. If you don't specify a value,
         * then the default DB cluster parameter group for the specified DB engine and version is used.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DB cluster parameter group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with this DB cluster. If you don't specify a
         *        value, then the default DB cluster parameter group for the specified DB engine and version is
         *        used.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DB cluster parameter group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with this DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with this DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * A DB subnet group to associate with this DB cluster.
         * </p>
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the name of an existing DB subnet group.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not be <code>default</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        A DB subnet group to associate with this DB cluster.</p>
         *        <p>
         *        This setting is required to create a Multi-AZ DB cluster.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the name of an existing DB subnet group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not be <code>default</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The database engine to use for this DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Valid Values: <code>aurora-mysql | aurora-postgresql | mysql | postgres</code>
         * </p>
         * 
         * @param engine
         *        The database engine to use for this DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Valid Values: <code>aurora-mysql | aurora-postgresql | mysql | postgres</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the database engine to use.
         * </p>
         * <p>
         * To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (MySQL
         * 8.0-compatible), use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for Aurora MySQL
         * version 2 or version 3, respectively.
         * </p>
         * <p>
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * For information about a specific engine, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora MySQL - see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database engine
         * updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora PostgreSQL - see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html"
         * >Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         * >Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon
         * RDS for PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to use.</p>
         *        <p>
         *        To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3
         *        (MySQL 8.0-compatible), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for
         *        Aurora MySQL version 2 or version 3, respectively.
         *        </p>
         *        <p>
         *        To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for RDS for MySQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        For information about a specific engine, see the following topics:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora MySQL - see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database
         *        engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora PostgreSQL - see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html"
         *        >Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         *        >Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
         *        >Amazon RDS for PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The port number on which the instances in the DB cluster accept connections.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * </p>
         * <p>
         * Default:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for MySQL and Aurora MySQL - <code>3306</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL and Aurora PostgreSQL - <code>5432</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param port
         *        The port number on which the instances in the DB cluster accept connections.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Valid Values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for MySQL and Aurora MySQL - <code>3306</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL and Aurora PostgreSQL - <code>5432</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the master user for the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 16 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The name of the master user for the DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master database user.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 8 to 41 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can contain any printable ASCII character except "/", """, or "@".
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The password for the master database user.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 8 to 41 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can contain any printable ASCII character except "/", """, or "@".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The option group to associate the DB cluster with.
         * </p>
         * <p>
         * DB clusters are associated with a default option group that can't be modified.
         * </p>
         * 
         * @param optionGroupName
         *        The option group to associate the DB cluster with.</p>
         *        <p>
         *        DB clusters are associated with a default option group that can't be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled using the
         * <code>BackupRetentionPeriod</code> parameter.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region. To view the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
         * > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled using
         *        the <code>BackupRetentionPeriod</code> parameter.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region. To view the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
         *        > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region, occurring on a random day of the week. To see the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region, occurring on a random day of the week. To see the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         *        > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a
         * read replica.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param replicationSourceIdentifier
         *        The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created
         *        as a read replica.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSourceIdentifier(String replicationSourceIdentifier);

        /**
         * <p>
         * Tags to assign to the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param tags
         *        Tags to assign to the DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to assign to the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param tags
         *        Tags to assign to the DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to assign to the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies whether the DB cluster is encrypted.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether the DB cluster is encrypted.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * When a KMS key isn't specified in <code>KmsKeyId</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS uses the KMS key
         * used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't
         * specified, then Amazon RDS uses your default KMS key.
         * </p>
         * </li>
         * </ul>
         * <p>
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make sure to
         * set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services
         * Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        When a KMS key isn't specified in <code>KmsKeyId</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS uses the
         *        KMS key used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code>
         *        isn't specified, then Amazon RDS uses your default KMS key.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
         *        a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make
         *        sure to set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web
         *        Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an URL
         * that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> operation to be
         * called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify
         * <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.
         * </p>
         * <p>
         * The presigned URL must be a valid request for the <code>CreateDBCluster</code> API operation that can run in
         * the source Amazon Web Services Region that contains the encrypted DB cluster to copy.
         * </p>
         * <p>
         * The presigned URL request must contain the following parameter values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster
         * in the destination Amazon Web Services Region. This should refer to the same KMS key for both the
         * <code>CreateDBCluster</code> operation that is called in the destination Amazon Web Services Region, and the
         * operation contained in the presigned URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be
         * created in.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be
         * copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services
         * Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services
         * Region, then your <code>ReplicationSourceIdentifier</code> would look like Example:
         * <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To learn how to generate a Signature Version 4 signed request, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests:
         * Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing
         * Process</a>.
         * </p>
         * <note>
         * <p>
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or
         * <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually.
         * Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation
         * that can run in the source Amazon Web Services Region.
         * </p>
         * </note>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param preSignedUrl
         *        When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an
         *        URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> operation
         *        to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify
         *        <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB
         *        cluster.</p>
         *        <p>
         *        The presigned URL must be a valid request for the <code>CreateDBCluster</code> API operation that can
         *        run in the source Amazon Web Services Region that contains the encrypted DB cluster to copy.
         *        </p>
         *        <p>
         *        The presigned URL request must contain the following parameter values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB
         *        cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both
         *        the <code>CreateDBCluster</code> operation that is called in the destination Amazon Web Services
         *        Region, and the operation contained in the presigned URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica
         *        will be created in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to
         *        be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web
         *        Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web
         *        Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example:
         *        <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To learn how to generate a Signature Version 4 signed request, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating
         *        Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4
         *        Signing Process</a>.
         *        </p>
         *        <note>
         *        <p>
         *        If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code>
         *        (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code>
         *        manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request
         *        for the operation that can run in the source Amazon Web Services Region.
         *        </p>
         *        </note>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);

        /**
         * <p>
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora MySQL DB clusters only
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         * </p>
         * </li>
         * </ul>
         * 
         * @param backtrackWindow
         *        The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>
         *        .</p>
         *        <p>
         *        Valid for Cluster Type: Aurora MySQL DB clusters only
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackWindow(Long backtrackWindow);

        /**
         * <p>
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The following values are valid for each DB engine:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora MySQL - <code>audit | error | general | slowquery</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora PostgreSQL - <code>postgresql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>error | general | slowquery</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql | upgrade</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        The following values are valid for each DB engine:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora MySQL - <code>audit | error | general | slowquery</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora PostgreSQL - <code>postgresql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>error | general | slowquery</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>postgresql | upgrade</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The following values are valid for each DB engine:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora MySQL - <code>audit | error | general | slowquery</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora PostgreSQL - <code>postgresql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>error | general | slowquery</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql | upgrade</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        The following values are valid for each DB engine:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora MySQL - <code>audit | error | general | slowquery</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora PostgreSQL - <code>postgresql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>error | general | slowquery</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>postgresql | upgrade</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.
         * </p>
         * <p>
         * The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters.
         * </p>
         * <p>
         * For information about limitations and requirements for Serverless DB clusters, see the following sections in
         * the <i>Amazon Aurora User Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"
         * >Limitations of Aurora Serverless v1</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html">
         * Requirements for Aurora Serverless v2</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param engineMode
         *        The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p>
         *        <p>
         *        The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters.
         *        </p>
         *        <p>
         *        For information about limitations and requirements for Serverless DB clusters, see the following
         *        sections in the <i>Amazon Aurora User Guide</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"
         *        >Limitations of Aurora Serverless v1</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html"
         *        >Requirements for Aurora Serverless v2</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineMode(String engineMode);

        /**
         * <p>
         * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param scalingConfiguration
         *        For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB
         *        cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfiguration scalingConfiguration);

        /**
         * <p>
         * For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfiguration(ScalingConfiguration)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfiguration)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfiguration.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion
         * protection is enabled. By default, deletion protection isn't enabled.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when
         *        deletion protection is enabled. By default, deletion protection isn't enabled.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database
         * cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param globalClusterIdentifier
         *        The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database
         *        cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP
         * endpoint is disabled.
         * </p>
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the
         * Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query
         * editor.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for
         * Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param enableHttpEndpoint
         *        Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the
         *        HTTP endpoint is disabled.</p>
         *        <p>
         *        When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on
         *        the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with
         *        the query editor.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API
         *        for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableHttpEndpoint(Boolean enableHttpEndpoint);

        /**
         * <p>
         * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to
         * copy them.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is
         *        not to copy them.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The Active Directory directory ID to create the DB cluster in.
         * </p>
         * <p>
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect
         * to the DB cluster.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
         * authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to create the DB cluster in.</p>
         *        <p>
         *        For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that
         *        connect to the DB cluster.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html"
         *        >Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the IAM role to use when making API calls to the Directory Service.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param domainIAMRoleName
         *        The name of the IAM role to use when making API calls to the Directory Service.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global
         * cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are
         * secondary clusters in an Aurora global database.
         * </p>
         * <p>
         * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this
         * parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting
         * changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this
         * value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing
         * until then.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param enableGlobalWriteForwarding
         *        Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a
         *        global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB
         *        clusters that are secondary clusters in an Aurora global database.</p>
         *        <p>
         *        You can set this value only on Aurora DB clusters that are members of an Aurora global database. With
         *        this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the
         *        resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global
         *        database, this value is used immediately if the primary is demoted by a global cluster API operation,
         *        but it does nothing until then.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding);

        /**
         * <p>
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
         * <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or
         * for all database engines.
         * </p>
         * <p>
         * For the full list of DB instance classes and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
         * class</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param dbClusterInstanceClass
         *        The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
         *        <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services
         *        Regions, or for all database engines.</p>
         *        <p>
         *        For the full list of DB instance classes and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        instance class</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting is required to create a Multi-AZ DB cluster.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterInstanceClass(String dbClusterInstanceClass);

        /**
         * <p>
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB
         *        cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        This setting is required to create a Multi-AZ DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The storage type to associate with the DB cluster.
         * </p>
         * <p>
         * For information on storage types for Aurora DB clusters, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
         * >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ DB
         * clusters, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
         * >Settings for creating Multi-AZ DB clusters</a>.
         * </p>
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * </p>
         * <p>
         * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora DB clusters - <code>aurora | aurora-iopt1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Multi-AZ DB clusters - <code>io1</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora DB clusters - <code>aurora</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Multi-AZ DB clusters - <code>io1</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code>, the storage type
         * is returned in the response. The storage type isn't returned when you set it to <code>aurora</code>.
         * </p>
         * </note>
         * 
         * @param storageType
         *        The storage type to associate with the DB cluster.</p>
         *        <p>
         *        For information on storage types for Aurora DB clusters, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
         *        >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for
         *        Multi-AZ DB clusters, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
         *        >Settings for creating Multi-AZ DB clusters</a>.
         *        </p>
         *        <p>
         *        This setting is required to create a Multi-AZ DB cluster.
         *        </p>
         *        <p>
         *        When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora DB clusters - <code>aurora | aurora-iopt1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Multi-AZ DB clusters - <code>io1</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora DB clusters - <code>aurora</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Multi-AZ DB clusters - <code>io1</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code>, the
         *        storage type is returned in the response. The storage type isn't returned when you set it to
         *        <code>aurora</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
         * instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * For information about valid IOPS values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned IOPS
         * storage</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each
         *        DB instance in the Multi-AZ DB cluster.</p>
         *        <p>
         *        For information about valid IOPS values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned
         *        IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting is required to create a Multi-AZ DB cluster.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Specifies whether the DB cluster is publicly accessible.
         * </p>
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
         * address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from
         * outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it
         * uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         * </p>
         * <p>
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to
         * a private IP address.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * </p>
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         * </p>
         * </li>
         * </ul>
         * 
         * @param publiclyAccessible
         *        Specifies whether the DB cluster is publicly accessible.</p>
         *        <p>
         *        When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public
         *        IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by
         *        the security group it uses. That public access isn't permitted if the security group assigned to the
         *        DB cluster doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *        </p>
         *        <p>
         *        If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't
         *        specified, the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB
         *        cluster is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified,
         *        the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster
         *        is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is
         *        public.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance
         * window. By default, minor engine upgrades are applied automatically.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Specifies whether minor engine upgrades are applied automatically to the DB cluster during the
         *        maintenance window. By default, minor engine upgrades are applied automatically.</p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         * To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other
         * than <code>0</code>.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value
         *        other than <code>0</code>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to
         * Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on
         * creating a monitoring role, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         * >Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param monitoringRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics
         *        to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For
         *        information on creating a monitoring role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         *        >Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
         *        <code>MonitoringRoleArn</code> value.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * Specifies whether to turn on Performance Insights for the DB cluster.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon
         * Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param enablePerformanceInsights
         *        Specifies whether to turn on Performance Insights for the DB cluster.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon
         *        Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months *
         * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>731</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>7</code> days
         * </p>
         * <p>
         * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data.</p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
         *        months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>731</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>7</code> days
         *        </p>
         *        <p>
         *        If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * @param serverlessV2ScalingConfiguration
         *        The new value for the ServerlessV2ScalingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServerlessV2ScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerlessV2ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessV2ScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)}.
         * 
         * @param serverlessV2ScalingConfiguration
         *        a consumer that will call methods on {@link ServerlessV2ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)
         */
        default Builder serverlessV2ScalingConfiguration(
                Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.builder()
                    .applyMutation(serverlessV2ScalingConfiguration).build());
        }

        /**
         * <p>
         * The network type of the DB cluster.
         * </p>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * <p>
         * Valid Values: <code>IPV4 | DUAL</code>
         * </p>
         * 
         * @param networkType
         *        The network type of the DB cluster.</p>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"
         *        > Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         *        </p>
         *        <p>
         *        Valid Values: <code>IPV4 | DUAL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param dbSystemId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSystemId(String dbSystemId);

        /**
         * <p>
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management
         * with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
         * management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't manage the master user password with Amazon Web Services Secrets Manager if
         * <code>MasterUserPassword</code> is specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param manageMasterUserPassword
         *        Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't manage the master user password with Amazon Web Services Secrets Manager if
         *        <code>MasterUserPassword</code> is specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterUserPassword(Boolean manageMasterUserPassword);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
         * Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
         * Manager for the DB cluster.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key
         * is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't
         * use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed
         * KMS key.
         * </p>
         * <p>
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param masterUserSecretKmsKeyId
         *        The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
         *        managed in Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        This setting is valid only if the master user password is managed by RDS in Amazon Web Services
         *        Secrets Manager for the DB cluster.
         *        </p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code>
         *        KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account,
         *        then you can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use
         *        a customer managed KMS key.
         *        </p>
         *        <p>
         *        There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
         *        a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId);

        /**
         * <p>
         * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By
         * default, write operations aren't allowed on reader DB instances.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param enableLocalWriteForwarding
         *        Specifies whether read replicas can forward write operations to the writer DB instance in the DB
         *        cluster. By default, write operations aren't allowed on reader DB instances.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding);

        /**
         * If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl
         * will be generated automatically by the SDK.
         * 
         * @param sourceRegion
         *        If PreSignedUrl is not specified, this is the region where the source snapshot is located. A
         *        PreSignedUrl will be generated automatically by the SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer backupRetentionPeriod;

        private String characterSetName;

        private String databaseName;

        private String dbClusterIdentifier;

        private String dbClusterParameterGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String dbSubnetGroupName;

        private String engine;

        private String engineVersion;

        private Integer port;

        private String masterUsername;

        private String masterUserPassword;

        private String optionGroupName;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private String replicationSourceIdentifier;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String preSignedUrl;

        private Boolean enableIAMDatabaseAuthentication;

        private Long backtrackWindow;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private String engineMode;

        private ScalingConfiguration scalingConfiguration;

        private Boolean deletionProtection;

        private String globalClusterIdentifier;

        private Boolean enableHttpEndpoint;

        private Boolean copyTagsToSnapshot;

        private String domain;

        private String domainIAMRoleName;

        private Boolean enableGlobalWriteForwarding;

        private String dbClusterInstanceClass;

        private Integer allocatedStorage;

        private String storageType;

        private Integer iops;

        private Boolean publiclyAccessible;

        private Boolean autoMinorVersionUpgrade;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

        private String networkType;

        private String dbSystemId;

        private Boolean manageMasterUserPassword;

        private String masterUserSecretKmsKeyId;

        private Boolean enableLocalWriteForwarding;

        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbClusterRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            backupRetentionPeriod(model.backupRetentionPeriod);
            characterSetName(model.characterSetName);
            databaseName(model.databaseName);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            dbSubnetGroupName(model.dbSubnetGroupName);
            engine(model.engine);
            engineVersion(model.engineVersion);
            port(model.port);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            optionGroupName(model.optionGroupName);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            replicationSourceIdentifier(model.replicationSourceIdentifier);
            tags(model.tags);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            preSignedUrl(model.preSignedUrl);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            backtrackWindow(model.backtrackWindow);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            engineMode(model.engineMode);
            scalingConfiguration(model.scalingConfiguration);
            deletionProtection(model.deletionProtection);
            globalClusterIdentifier(model.globalClusterIdentifier);
            enableHttpEndpoint(model.enableHttpEndpoint);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
            enableGlobalWriteForwarding(model.enableGlobalWriteForwarding);
            dbClusterInstanceClass(model.dbClusterInstanceClass);
            allocatedStorage(model.allocatedStorage);
            storageType(model.storageType);
            iops(model.iops);
            publiclyAccessible(model.publiclyAccessible);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            networkType(model.networkType);
            dbSystemId(model.dbSystemId);
            manageMasterUserPassword(model.manageMasterUserPassword);
            masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            enableLocalWriteForwarding(model.enableLocalWriteForwarding);
            sourceRegion(model.sourceRegion);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSourceIdentifier() {
            return replicationSourceIdentifier;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Long getBacktrackWindow() {
            return backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final String getEngineMode() {
            return engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final Boolean getEnableHttpEndpoint() {
            return enableHttpEndpoint;
        }

        public final void setEnableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
        }

        @Override
        public final Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final Boolean getEnableGlobalWriteForwarding() {
            return enableGlobalWriteForwarding;
        }

        public final void setEnableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
        }

        @Override
        public final Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(
                ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final String getDbSystemId() {
            return dbSystemId;
        }

        public final void setDbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
        }

        @Override
        public final Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final Boolean getEnableLocalWriteForwarding() {
            return enableLocalWriteForwarding;
        }

        public final void setEnableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
        }

        @Override
        public final Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbClusterRequest build() {
            return new CreateDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
