/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DBProxyEndpoint;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse;

public class DescribeDBProxyEndpointsPublisher
implements SdkPublisher<DescribeDbProxyEndpointsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbProxyEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBProxyEndpointsPublisher(RdsAsyncClient client, DescribeDbProxyEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBProxyEndpointsPublisher(RdsAsyncClient client, DescribeDbProxyEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbProxyEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbProxyEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBProxyEndpoint> dbProxyEndpoints() {
        Function<DescribeDbProxyEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbProxyEndpoints() != null) {
                return response.dbProxyEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbProxyEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbProxyEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeDbProxyEndpointsResponse> {
        private DescribeDbProxyEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxyEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbProxyEndpointsResponse> nextPage(DescribeDbProxyEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxyEndpointsPublisher.this.client.describeDBProxyEndpoints(DescribeDBProxyEndpointsPublisher.this.firstRequest);
            }
            return DescribeDBProxyEndpointsPublisher.this.client.describeDBProxyEndpoints((DescribeDbProxyEndpointsRequest)((Object)DescribeDBProxyEndpointsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

