/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockRuleRequest extends RbinRequest implements ToCopyableBuilder<LockRuleRequest.Builder, LockRuleRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(LockRuleRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<LockConfiguration> LOCK_CONFIGURATION_FIELD = SdkField
            .<LockConfiguration> builder(MarshallingType.SDK_POJO).memberName("LockConfiguration")
            .getter(getter(LockRuleRequest::lockConfiguration)).setter(setter(Builder::lockConfiguration))
            .constructor(LockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LOCK_CONFIGURATION_FIELD));

    private final String identifier;

    private final LockConfiguration lockConfiguration;

    private LockRuleRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.lockConfiguration = builder.lockConfiguration;
    }

    /**
     * <p>
     * The unique ID of the retention rule.
     * </p>
     * 
     * @return The unique ID of the retention rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Information about the retention rule lock configuration.
     * </p>
     * 
     * @return Information about the retention rule lock configuration.
     */
    public final LockConfiguration lockConfiguration() {
        return lockConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(lockConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockRuleRequest)) {
            return false;
        }
        LockRuleRequest other = (LockRuleRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(lockConfiguration(), other.lockConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LockRuleRequest").add("Identifier", identifier()).add("LockConfiguration", lockConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "LockConfiguration":
            return Optional.ofNullable(clazz.cast(lockConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LockRuleRequest, T> g) {
        return obj -> g.apply((LockRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RbinRequest.Builder, SdkPojo, CopyableBuilder<Builder, LockRuleRequest> {
        /**
         * <p>
         * The unique ID of the retention rule.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Information about the retention rule lock configuration.
         * </p>
         * 
         * @param lockConfiguration
         *        Information about the retention rule lock configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockConfiguration(LockConfiguration lockConfiguration);

        /**
         * <p>
         * Information about the retention rule lock configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LockConfiguration.Builder} avoiding the
         * need to create one manually via {@link LockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LockConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #lockConfiguration(LockConfiguration)}.
         * 
         * @param lockConfiguration
         *        a consumer that will call methods on {@link LockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockConfiguration(LockConfiguration)
         */
        default Builder lockConfiguration(Consumer<LockConfiguration.Builder> lockConfiguration) {
            return lockConfiguration(LockConfiguration.builder().applyMutation(lockConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RbinRequest.BuilderImpl implements Builder {
        private String identifier;

        private LockConfiguration lockConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LockRuleRequest model) {
            super(model);
            identifier(model.identifier);
            lockConfiguration(model.lockConfiguration);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final LockConfiguration.Builder getLockConfiguration() {
            return lockConfiguration != null ? lockConfiguration.toBuilder() : null;
        }

        public final void setLockConfiguration(LockConfiguration.BuilderImpl lockConfiguration) {
            this.lockConfiguration = lockConfiguration != null ? lockConfiguration.build() : null;
        }

        @Override
        public final Builder lockConfiguration(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LockRuleRequest build() {
            return new LockRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
