/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The measure (metric) type field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeasureField implements SdkPojo, Serializable, ToCopyableBuilder<MeasureField.Builder, MeasureField> {
    private static final SdkField<NumericalMeasureField> NUMERICAL_MEASURE_FIELD_FIELD = SdkField
            .<NumericalMeasureField> builder(MarshallingType.SDK_POJO).memberName("NumericalMeasureField")
            .getter(getter(MeasureField::numericalMeasureField)).setter(setter(Builder::numericalMeasureField))
            .constructor(NumericalMeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericalMeasureField").build())
            .build();

    private static final SdkField<CategoricalMeasureField> CATEGORICAL_MEASURE_FIELD_FIELD = SdkField
            .<CategoricalMeasureField> builder(MarshallingType.SDK_POJO).memberName("CategoricalMeasureField")
            .getter(getter(MeasureField::categoricalMeasureField)).setter(setter(Builder::categoricalMeasureField))
            .constructor(CategoricalMeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalMeasureField").build())
            .build();

    private static final SdkField<DateMeasureField> DATE_MEASURE_FIELD_FIELD = SdkField
            .<DateMeasureField> builder(MarshallingType.SDK_POJO).memberName("DateMeasureField")
            .getter(getter(MeasureField::dateMeasureField)).setter(setter(Builder::dateMeasureField))
            .constructor(DateMeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateMeasureField").build()).build();

    private static final SdkField<CalculatedMeasureField> CALCULATED_MEASURE_FIELD_FIELD = SdkField
            .<CalculatedMeasureField> builder(MarshallingType.SDK_POJO).memberName("CalculatedMeasureField")
            .getter(getter(MeasureField::calculatedMeasureField)).setter(setter(Builder::calculatedMeasureField))
            .constructor(CalculatedMeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedMeasureField").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERICAL_MEASURE_FIELD_FIELD,
            CATEGORICAL_MEASURE_FIELD_FIELD, DATE_MEASURE_FIELD_FIELD, CALCULATED_MEASURE_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final NumericalMeasureField numericalMeasureField;

    private final CategoricalMeasureField categoricalMeasureField;

    private final DateMeasureField dateMeasureField;

    private final CalculatedMeasureField calculatedMeasureField;

    private MeasureField(BuilderImpl builder) {
        this.numericalMeasureField = builder.numericalMeasureField;
        this.categoricalMeasureField = builder.categoricalMeasureField;
        this.dateMeasureField = builder.dateMeasureField;
        this.calculatedMeasureField = builder.calculatedMeasureField;
    }

    /**
     * <p>
     * The measure type field with numerical type columns.
     * </p>
     * 
     * @return The measure type field with numerical type columns.
     */
    public final NumericalMeasureField numericalMeasureField() {
        return numericalMeasureField;
    }

    /**
     * <p>
     * The measure type field with categorical type columns.
     * </p>
     * 
     * @return The measure type field with categorical type columns.
     */
    public final CategoricalMeasureField categoricalMeasureField() {
        return categoricalMeasureField;
    }

    /**
     * <p>
     * The measure type field with date type columns.
     * </p>
     * 
     * @return The measure type field with date type columns.
     */
    public final DateMeasureField dateMeasureField() {
        return dateMeasureField;
    }

    /**
     * <p>
     * The calculated measure field only used in pivot tables.
     * </p>
     * 
     * @return The calculated measure field only used in pivot tables.
     */
    public final CalculatedMeasureField calculatedMeasureField() {
        return calculatedMeasureField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numericalMeasureField());
        hashCode = 31 * hashCode + Objects.hashCode(categoricalMeasureField());
        hashCode = 31 * hashCode + Objects.hashCode(dateMeasureField());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedMeasureField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeasureField)) {
            return false;
        }
        MeasureField other = (MeasureField) obj;
        return Objects.equals(numericalMeasureField(), other.numericalMeasureField())
                && Objects.equals(categoricalMeasureField(), other.categoricalMeasureField())
                && Objects.equals(dateMeasureField(), other.dateMeasureField())
                && Objects.equals(calculatedMeasureField(), other.calculatedMeasureField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeasureField").add("NumericalMeasureField", numericalMeasureField())
                .add("CategoricalMeasureField", categoricalMeasureField()).add("DateMeasureField", dateMeasureField())
                .add("CalculatedMeasureField", calculatedMeasureField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumericalMeasureField":
            return Optional.ofNullable(clazz.cast(numericalMeasureField()));
        case "CategoricalMeasureField":
            return Optional.ofNullable(clazz.cast(categoricalMeasureField()));
        case "DateMeasureField":
            return Optional.ofNullable(clazz.cast(dateMeasureField()));
        case "CalculatedMeasureField":
            return Optional.ofNullable(clazz.cast(calculatedMeasureField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeasureField, T> g) {
        return obj -> g.apply((MeasureField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeasureField> {
        /**
         * <p>
         * The measure type field with numerical type columns.
         * </p>
         * 
         * @param numericalMeasureField
         *        The measure type field with numerical type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericalMeasureField(NumericalMeasureField numericalMeasureField);

        /**
         * <p>
         * The measure type field with numerical type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericalMeasureField.Builder} avoiding
         * the need to create one manually via {@link NumericalMeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericalMeasureField.Builder#build()} is called immediately and
         * its result is passed to {@link #numericalMeasureField(NumericalMeasureField)}.
         * 
         * @param numericalMeasureField
         *        a consumer that will call methods on {@link NumericalMeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericalMeasureField(NumericalMeasureField)
         */
        default Builder numericalMeasureField(Consumer<NumericalMeasureField.Builder> numericalMeasureField) {
            return numericalMeasureField(NumericalMeasureField.builder().applyMutation(numericalMeasureField).build());
        }

        /**
         * <p>
         * The measure type field with categorical type columns.
         * </p>
         * 
         * @param categoricalMeasureField
         *        The measure type field with categorical type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalMeasureField(CategoricalMeasureField categoricalMeasureField);

        /**
         * <p>
         * The measure type field with categorical type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoricalMeasureField.Builder} avoiding
         * the need to create one manually via {@link CategoricalMeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoricalMeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #categoricalMeasureField(CategoricalMeasureField)}.
         * 
         * @param categoricalMeasureField
         *        a consumer that will call methods on {@link CategoricalMeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalMeasureField(CategoricalMeasureField)
         */
        default Builder categoricalMeasureField(Consumer<CategoricalMeasureField.Builder> categoricalMeasureField) {
            return categoricalMeasureField(CategoricalMeasureField.builder().applyMutation(categoricalMeasureField).build());
        }

        /**
         * <p>
         * The measure type field with date type columns.
         * </p>
         * 
         * @param dateMeasureField
         *        The measure type field with date type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateMeasureField(DateMeasureField dateMeasureField);

        /**
         * <p>
         * The measure type field with date type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateMeasureField.Builder} avoiding the
         * need to create one manually via {@link DateMeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateMeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #dateMeasureField(DateMeasureField)}.
         * 
         * @param dateMeasureField
         *        a consumer that will call methods on {@link DateMeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateMeasureField(DateMeasureField)
         */
        default Builder dateMeasureField(Consumer<DateMeasureField.Builder> dateMeasureField) {
            return dateMeasureField(DateMeasureField.builder().applyMutation(dateMeasureField).build());
        }

        /**
         * <p>
         * The calculated measure field only used in pivot tables.
         * </p>
         * 
         * @param calculatedMeasureField
         *        The calculated measure field only used in pivot tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedMeasureField(CalculatedMeasureField calculatedMeasureField);

        /**
         * <p>
         * The calculated measure field only used in pivot tables.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculatedMeasureField.Builder} avoiding
         * the need to create one manually via {@link CalculatedMeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculatedMeasureField.Builder#build()} is called immediately and
         * its result is passed to {@link #calculatedMeasureField(CalculatedMeasureField)}.
         * 
         * @param calculatedMeasureField
         *        a consumer that will call methods on {@link CalculatedMeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedMeasureField(CalculatedMeasureField)
         */
        default Builder calculatedMeasureField(Consumer<CalculatedMeasureField.Builder> calculatedMeasureField) {
            return calculatedMeasureField(CalculatedMeasureField.builder().applyMutation(calculatedMeasureField).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumericalMeasureField numericalMeasureField;

        private CategoricalMeasureField categoricalMeasureField;

        private DateMeasureField dateMeasureField;

        private CalculatedMeasureField calculatedMeasureField;

        private BuilderImpl() {
        }

        private BuilderImpl(MeasureField model) {
            numericalMeasureField(model.numericalMeasureField);
            categoricalMeasureField(model.categoricalMeasureField);
            dateMeasureField(model.dateMeasureField);
            calculatedMeasureField(model.calculatedMeasureField);
        }

        public final NumericalMeasureField.Builder getNumericalMeasureField() {
            return numericalMeasureField != null ? numericalMeasureField.toBuilder() : null;
        }

        public final void setNumericalMeasureField(NumericalMeasureField.BuilderImpl numericalMeasureField) {
            this.numericalMeasureField = numericalMeasureField != null ? numericalMeasureField.build() : null;
        }

        @Override
        public final Builder numericalMeasureField(NumericalMeasureField numericalMeasureField) {
            this.numericalMeasureField = numericalMeasureField;
            return this;
        }

        public final CategoricalMeasureField.Builder getCategoricalMeasureField() {
            return categoricalMeasureField != null ? categoricalMeasureField.toBuilder() : null;
        }

        public final void setCategoricalMeasureField(CategoricalMeasureField.BuilderImpl categoricalMeasureField) {
            this.categoricalMeasureField = categoricalMeasureField != null ? categoricalMeasureField.build() : null;
        }

        @Override
        public final Builder categoricalMeasureField(CategoricalMeasureField categoricalMeasureField) {
            this.categoricalMeasureField = categoricalMeasureField;
            return this;
        }

        public final DateMeasureField.Builder getDateMeasureField() {
            return dateMeasureField != null ? dateMeasureField.toBuilder() : null;
        }

        public final void setDateMeasureField(DateMeasureField.BuilderImpl dateMeasureField) {
            this.dateMeasureField = dateMeasureField != null ? dateMeasureField.build() : null;
        }

        @Override
        public final Builder dateMeasureField(DateMeasureField dateMeasureField) {
            this.dateMeasureField = dateMeasureField;
            return this;
        }

        public final CalculatedMeasureField.Builder getCalculatedMeasureField() {
            return calculatedMeasureField != null ? calculatedMeasureField.toBuilder() : null;
        }

        public final void setCalculatedMeasureField(CalculatedMeasureField.BuilderImpl calculatedMeasureField) {
            this.calculatedMeasureField = calculatedMeasureField != null ? calculatedMeasureField.build() : null;
        }

        @Override
        public final Builder calculatedMeasureField(CalculatedMeasureField calculatedMeasureField) {
            this.calculatedMeasureField = calculatedMeasureField;
            return this;
        }

        @Override
        public MeasureField build() {
            return new MeasureField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
