/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tooltip item for the fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldTooltipItem implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldTooltipItem.Builder, FieldTooltipItem> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(FieldTooltipItem::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(FieldTooltipItem::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(FieldTooltipItem::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, LABEL_FIELD,
            VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String label;

    private final String visibility;

    private FieldTooltipItem(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.label = builder.label;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * The unique ID of the field that is targeted by the tooltip.
     * </p>
     * 
     * @return The unique ID of the field that is targeted by the tooltip.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The label of the tooltip item.
     * </p>
     * 
     * @return The label of the tooltip item.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The visibility of the tooltip item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the tooltip item.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the tooltip item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the tooltip item.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldTooltipItem)) {
            return false;
        }
        FieldTooltipItem other = (FieldTooltipItem) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(label(), other.label())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldTooltipItem").add("FieldId", fieldId()).add("Label", label())
                .add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldTooltipItem, T> g) {
        return obj -> g.apply((FieldTooltipItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldTooltipItem> {
        /**
         * <p>
         * The unique ID of the field that is targeted by the tooltip.
         * </p>
         * 
         * @param fieldId
         *        The unique ID of the field that is targeted by the tooltip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The label of the tooltip item.
         * </p>
         * 
         * @param label
         *        The label of the tooltip item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The visibility of the tooltip item.
         * </p>
         * 
         * @param visibility
         *        The visibility of the tooltip item.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the tooltip item.
         * </p>
         * 
         * @param visibility
         *        The visibility of the tooltip item.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String label;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldTooltipItem model) {
            fieldId(model.fieldId);
            label(model.label);
            visibility(model.visibility);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public FieldTooltipItem build() {
            return new FieldTooltipItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
