/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.CastColumnTypeOperation;
import software.amazon.awssdk.services.quicksight.model.CreateColumnsOperation;
import software.amazon.awssdk.services.quicksight.model.FilterOperation;
import software.amazon.awssdk.services.quicksight.model.OverrideDatasetParameterOperation;
import software.amazon.awssdk.services.quicksight.model.ProjectOperation;
import software.amazon.awssdk.services.quicksight.model.RenameColumnOperation;
import software.amazon.awssdk.services.quicksight.model.TagColumnOperation;
import software.amazon.awssdk.services.quicksight.model.UntagColumnOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformOperation> {
    private static final SdkField<ProjectOperation> PROJECT_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProjectOperation").getter(TransformOperation.getter(TransformOperation::projectOperation)).setter(TransformOperation.setter(Builder::projectOperation)).constructor(ProjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectOperation").build()}).build();
    private static final SdkField<FilterOperation> FILTER_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterOperation").getter(TransformOperation.getter(TransformOperation::filterOperation)).setter(TransformOperation.setter(Builder::filterOperation)).constructor(FilterOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()}).build();
    private static final SdkField<CreateColumnsOperation> CREATE_COLUMNS_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateColumnsOperation").getter(TransformOperation.getter(TransformOperation::createColumnsOperation)).setter(TransformOperation.setter(Builder::createColumnsOperation)).constructor(CreateColumnsOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumnsOperation").build()}).build();
    private static final SdkField<RenameColumnOperation> RENAME_COLUMN_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenameColumnOperation").getter(TransformOperation.getter(TransformOperation::renameColumnOperation)).setter(TransformOperation.setter(Builder::renameColumnOperation)).constructor(RenameColumnOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnOperation").build()}).build();
    private static final SdkField<CastColumnTypeOperation> CAST_COLUMN_TYPE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CastColumnTypeOperation").getter(TransformOperation.getter(TransformOperation::castColumnTypeOperation)).setter(TransformOperation.setter(Builder::castColumnTypeOperation)).constructor(CastColumnTypeOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypeOperation").build()}).build();
    private static final SdkField<TagColumnOperation> TAG_COLUMN_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagColumnOperation").getter(TransformOperation.getter(TransformOperation::tagColumnOperation)).setter(TransformOperation.setter(Builder::tagColumnOperation)).constructor(TagColumnOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagColumnOperation").build()}).build();
    private static final SdkField<UntagColumnOperation> UNTAG_COLUMN_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UntagColumnOperation").getter(TransformOperation.getter(TransformOperation::untagColumnOperation)).setter(TransformOperation.setter(Builder::untagColumnOperation)).constructor(UntagColumnOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UntagColumnOperation").build()}).build();
    private static final SdkField<OverrideDatasetParameterOperation> OVERRIDE_DATASET_PARAMETER_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideDatasetParameterOperation").getter(TransformOperation.getter(TransformOperation::overrideDatasetParameterOperation)).setter(TransformOperation.setter(Builder::overrideDatasetParameterOperation)).constructor(OverrideDatasetParameterOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideDatasetParameterOperation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_OPERATION_FIELD, FILTER_OPERATION_FIELD, CREATE_COLUMNS_OPERATION_FIELD, RENAME_COLUMN_OPERATION_FIELD, CAST_COLUMN_TYPE_OPERATION_FIELD, TAG_COLUMN_OPERATION_FIELD, UNTAG_COLUMN_OPERATION_FIELD, OVERRIDE_DATASET_PARAMETER_OPERATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProjectOperation projectOperation;
    private final FilterOperation filterOperation;
    private final CreateColumnsOperation createColumnsOperation;
    private final RenameColumnOperation renameColumnOperation;
    private final CastColumnTypeOperation castColumnTypeOperation;
    private final TagColumnOperation tagColumnOperation;
    private final UntagColumnOperation untagColumnOperation;
    private final OverrideDatasetParameterOperation overrideDatasetParameterOperation;
    private final Type type;

    private TransformOperation(BuilderImpl builder) {
        this.projectOperation = builder.projectOperation;
        this.filterOperation = builder.filterOperation;
        this.createColumnsOperation = builder.createColumnsOperation;
        this.renameColumnOperation = builder.renameColumnOperation;
        this.castColumnTypeOperation = builder.castColumnTypeOperation;
        this.tagColumnOperation = builder.tagColumnOperation;
        this.untagColumnOperation = builder.untagColumnOperation;
        this.overrideDatasetParameterOperation = builder.overrideDatasetParameterOperation;
        this.type = builder.type;
    }

    public final ProjectOperation projectOperation() {
        return this.projectOperation;
    }

    public final FilterOperation filterOperation() {
        return this.filterOperation;
    }

    public final CreateColumnsOperation createColumnsOperation() {
        return this.createColumnsOperation;
    }

    public final RenameColumnOperation renameColumnOperation() {
        return this.renameColumnOperation;
    }

    public final CastColumnTypeOperation castColumnTypeOperation() {
        return this.castColumnTypeOperation;
    }

    public final TagColumnOperation tagColumnOperation() {
        return this.tagColumnOperation;
    }

    public final UntagColumnOperation untagColumnOperation() {
        return this.untagColumnOperation;
    }

    public final OverrideDatasetParameterOperation overrideDatasetParameterOperation() {
        return this.overrideDatasetParameterOperation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.createColumnsOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.castColumnTypeOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.untagColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideDatasetParameterOperation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOperation)) {
            return false;
        }
        TransformOperation other = (TransformOperation)obj;
        return Objects.equals(this.projectOperation(), other.projectOperation()) && Objects.equals(this.filterOperation(), other.filterOperation()) && Objects.equals(this.createColumnsOperation(), other.createColumnsOperation()) && Objects.equals(this.renameColumnOperation(), other.renameColumnOperation()) && Objects.equals(this.castColumnTypeOperation(), other.castColumnTypeOperation()) && Objects.equals(this.tagColumnOperation(), other.tagColumnOperation()) && Objects.equals(this.untagColumnOperation(), other.untagColumnOperation()) && Objects.equals(this.overrideDatasetParameterOperation(), other.overrideDatasetParameterOperation());
    }

    public final String toString() {
        return ToString.builder((String)"TransformOperation").add("ProjectOperation", (Object)this.projectOperation()).add("FilterOperation", (Object)this.filterOperation()).add("CreateColumnsOperation", (Object)this.createColumnsOperation()).add("RenameColumnOperation", (Object)this.renameColumnOperation()).add("CastColumnTypeOperation", (Object)this.castColumnTypeOperation()).add("TagColumnOperation", (Object)this.tagColumnOperation()).add("UntagColumnOperation", (Object)this.untagColumnOperation()).add("OverrideDatasetParameterOperation", (Object)this.overrideDatasetParameterOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectOperation": {
                return Optional.ofNullable(clazz.cast(this.projectOperation()));
            }
            case "FilterOperation": {
                return Optional.ofNullable(clazz.cast(this.filterOperation()));
            }
            case "CreateColumnsOperation": {
                return Optional.ofNullable(clazz.cast(this.createColumnsOperation()));
            }
            case "RenameColumnOperation": {
                return Optional.ofNullable(clazz.cast(this.renameColumnOperation()));
            }
            case "CastColumnTypeOperation": {
                return Optional.ofNullable(clazz.cast(this.castColumnTypeOperation()));
            }
            case "TagColumnOperation": {
                return Optional.ofNullable(clazz.cast(this.tagColumnOperation()));
            }
            case "UntagColumnOperation": {
                return Optional.ofNullable(clazz.cast(this.untagColumnOperation()));
            }
            case "OverrideDatasetParameterOperation": {
                return Optional.ofNullable(clazz.cast(this.overrideDatasetParameterOperation()));
            }
        }
        return Optional.empty();
    }

    public static TransformOperation fromProjectOperation(ProjectOperation projectOperation) {
        return (TransformOperation)TransformOperation.builder().projectOperation(projectOperation).build();
    }

    public static TransformOperation fromProjectOperation(Consumer<ProjectOperation.Builder> projectOperation) {
        ProjectOperation.Builder builder = ProjectOperation.builder();
        projectOperation.accept(builder);
        return TransformOperation.fromProjectOperation((ProjectOperation)builder.build());
    }

    public static TransformOperation fromFilterOperation(FilterOperation filterOperation) {
        return (TransformOperation)TransformOperation.builder().filterOperation(filterOperation).build();
    }

    public static TransformOperation fromFilterOperation(Consumer<FilterOperation.Builder> filterOperation) {
        FilterOperation.Builder builder = FilterOperation.builder();
        filterOperation.accept(builder);
        return TransformOperation.fromFilterOperation((FilterOperation)builder.build());
    }

    public static TransformOperation fromCreateColumnsOperation(CreateColumnsOperation createColumnsOperation) {
        return (TransformOperation)TransformOperation.builder().createColumnsOperation(createColumnsOperation).build();
    }

    public static TransformOperation fromCreateColumnsOperation(Consumer<CreateColumnsOperation.Builder> createColumnsOperation) {
        CreateColumnsOperation.Builder builder = CreateColumnsOperation.builder();
        createColumnsOperation.accept(builder);
        return TransformOperation.fromCreateColumnsOperation((CreateColumnsOperation)builder.build());
    }

    public static TransformOperation fromRenameColumnOperation(RenameColumnOperation renameColumnOperation) {
        return (TransformOperation)TransformOperation.builder().renameColumnOperation(renameColumnOperation).build();
    }

    public static TransformOperation fromRenameColumnOperation(Consumer<RenameColumnOperation.Builder> renameColumnOperation) {
        RenameColumnOperation.Builder builder = RenameColumnOperation.builder();
        renameColumnOperation.accept(builder);
        return TransformOperation.fromRenameColumnOperation((RenameColumnOperation)builder.build());
    }

    public static TransformOperation fromCastColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation) {
        return (TransformOperation)TransformOperation.builder().castColumnTypeOperation(castColumnTypeOperation).build();
    }

    public static TransformOperation fromCastColumnTypeOperation(Consumer<CastColumnTypeOperation.Builder> castColumnTypeOperation) {
        CastColumnTypeOperation.Builder builder = CastColumnTypeOperation.builder();
        castColumnTypeOperation.accept(builder);
        return TransformOperation.fromCastColumnTypeOperation((CastColumnTypeOperation)builder.build());
    }

    public static TransformOperation fromTagColumnOperation(TagColumnOperation tagColumnOperation) {
        return (TransformOperation)TransformOperation.builder().tagColumnOperation(tagColumnOperation).build();
    }

    public static TransformOperation fromTagColumnOperation(Consumer<TagColumnOperation.Builder> tagColumnOperation) {
        TagColumnOperation.Builder builder = TagColumnOperation.builder();
        tagColumnOperation.accept(builder);
        return TransformOperation.fromTagColumnOperation((TagColumnOperation)builder.build());
    }

    public static TransformOperation fromUntagColumnOperation(UntagColumnOperation untagColumnOperation) {
        return (TransformOperation)TransformOperation.builder().untagColumnOperation(untagColumnOperation).build();
    }

    public static TransformOperation fromUntagColumnOperation(Consumer<UntagColumnOperation.Builder> untagColumnOperation) {
        UntagColumnOperation.Builder builder = UntagColumnOperation.builder();
        untagColumnOperation.accept(builder);
        return TransformOperation.fromUntagColumnOperation((UntagColumnOperation)builder.build());
    }

    public static TransformOperation fromOverrideDatasetParameterOperation(OverrideDatasetParameterOperation overrideDatasetParameterOperation) {
        return (TransformOperation)TransformOperation.builder().overrideDatasetParameterOperation(overrideDatasetParameterOperation).build();
    }

    public static TransformOperation fromOverrideDatasetParameterOperation(Consumer<OverrideDatasetParameterOperation.Builder> overrideDatasetParameterOperation) {
        OverrideDatasetParameterOperation.Builder builder = OverrideDatasetParameterOperation.builder();
        overrideDatasetParameterOperation.accept(builder);
        return TransformOperation.fromOverrideDatasetParameterOperation((OverrideDatasetParameterOperation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformOperation, T> g) {
        return obj -> g.apply((TransformOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROJECT_OPERATION,
        FILTER_OPERATION,
        CREATE_COLUMNS_OPERATION,
        RENAME_COLUMN_OPERATION,
        CAST_COLUMN_TYPE_OPERATION,
        TAG_COLUMN_OPERATION,
        UNTAG_COLUMN_OPERATION,
        OVERRIDE_DATASET_PARAMETER_OPERATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProjectOperation projectOperation;
        private FilterOperation filterOperation;
        private CreateColumnsOperation createColumnsOperation;
        private RenameColumnOperation renameColumnOperation;
        private CastColumnTypeOperation castColumnTypeOperation;
        private TagColumnOperation tagColumnOperation;
        private UntagColumnOperation untagColumnOperation;
        private OverrideDatasetParameterOperation overrideDatasetParameterOperation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOperation model) {
            this.projectOperation(model.projectOperation);
            this.filterOperation(model.filterOperation);
            this.createColumnsOperation(model.createColumnsOperation);
            this.renameColumnOperation(model.renameColumnOperation);
            this.castColumnTypeOperation(model.castColumnTypeOperation);
            this.tagColumnOperation(model.tagColumnOperation);
            this.untagColumnOperation(model.untagColumnOperation);
            this.overrideDatasetParameterOperation(model.overrideDatasetParameterOperation);
        }

        public final ProjectOperation.Builder getProjectOperation() {
            return this.projectOperation != null ? this.projectOperation.toBuilder() : null;
        }

        public final void setProjectOperation(ProjectOperation.BuilderImpl projectOperation) {
            ProjectOperation oldValue = this.projectOperation;
            this.projectOperation = projectOperation != null ? projectOperation.build() : null;
            this.handleUnionValueChange(Type.PROJECT_OPERATION, oldValue, this.projectOperation);
        }

        @Override
        public final Builder projectOperation(ProjectOperation projectOperation) {
            ProjectOperation oldValue = this.projectOperation;
            this.projectOperation = projectOperation;
            this.handleUnionValueChange(Type.PROJECT_OPERATION, oldValue, this.projectOperation);
            return this;
        }

        public final FilterOperation.Builder getFilterOperation() {
            return this.filterOperation != null ? this.filterOperation.toBuilder() : null;
        }

        public final void setFilterOperation(FilterOperation.BuilderImpl filterOperation) {
            FilterOperation oldValue = this.filterOperation;
            this.filterOperation = filterOperation != null ? filterOperation.build() : null;
            this.handleUnionValueChange(Type.FILTER_OPERATION, oldValue, this.filterOperation);
        }

        @Override
        public final Builder filterOperation(FilterOperation filterOperation) {
            FilterOperation oldValue = this.filterOperation;
            this.filterOperation = filterOperation;
            this.handleUnionValueChange(Type.FILTER_OPERATION, oldValue, this.filterOperation);
            return this;
        }

        public final CreateColumnsOperation.Builder getCreateColumnsOperation() {
            return this.createColumnsOperation != null ? this.createColumnsOperation.toBuilder() : null;
        }

        public final void setCreateColumnsOperation(CreateColumnsOperation.BuilderImpl createColumnsOperation) {
            CreateColumnsOperation oldValue = this.createColumnsOperation;
            this.createColumnsOperation = createColumnsOperation != null ? createColumnsOperation.build() : null;
            this.handleUnionValueChange(Type.CREATE_COLUMNS_OPERATION, oldValue, this.createColumnsOperation);
        }

        @Override
        public final Builder createColumnsOperation(CreateColumnsOperation createColumnsOperation) {
            CreateColumnsOperation oldValue = this.createColumnsOperation;
            this.createColumnsOperation = createColumnsOperation;
            this.handleUnionValueChange(Type.CREATE_COLUMNS_OPERATION, oldValue, this.createColumnsOperation);
            return this;
        }

        public final RenameColumnOperation.Builder getRenameColumnOperation() {
            return this.renameColumnOperation != null ? this.renameColumnOperation.toBuilder() : null;
        }

        public final void setRenameColumnOperation(RenameColumnOperation.BuilderImpl renameColumnOperation) {
            RenameColumnOperation oldValue = this.renameColumnOperation;
            this.renameColumnOperation = renameColumnOperation != null ? renameColumnOperation.build() : null;
            this.handleUnionValueChange(Type.RENAME_COLUMN_OPERATION, oldValue, this.renameColumnOperation);
        }

        @Override
        public final Builder renameColumnOperation(RenameColumnOperation renameColumnOperation) {
            RenameColumnOperation oldValue = this.renameColumnOperation;
            this.renameColumnOperation = renameColumnOperation;
            this.handleUnionValueChange(Type.RENAME_COLUMN_OPERATION, oldValue, this.renameColumnOperation);
            return this;
        }

        public final CastColumnTypeOperation.Builder getCastColumnTypeOperation() {
            return this.castColumnTypeOperation != null ? this.castColumnTypeOperation.toBuilder() : null;
        }

        public final void setCastColumnTypeOperation(CastColumnTypeOperation.BuilderImpl castColumnTypeOperation) {
            CastColumnTypeOperation oldValue = this.castColumnTypeOperation;
            this.castColumnTypeOperation = castColumnTypeOperation != null ? castColumnTypeOperation.build() : null;
            this.handleUnionValueChange(Type.CAST_COLUMN_TYPE_OPERATION, oldValue, this.castColumnTypeOperation);
        }

        @Override
        public final Builder castColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation) {
            CastColumnTypeOperation oldValue = this.castColumnTypeOperation;
            this.castColumnTypeOperation = castColumnTypeOperation;
            this.handleUnionValueChange(Type.CAST_COLUMN_TYPE_OPERATION, oldValue, this.castColumnTypeOperation);
            return this;
        }

        public final TagColumnOperation.Builder getTagColumnOperation() {
            return this.tagColumnOperation != null ? this.tagColumnOperation.toBuilder() : null;
        }

        public final void setTagColumnOperation(TagColumnOperation.BuilderImpl tagColumnOperation) {
            TagColumnOperation oldValue = this.tagColumnOperation;
            this.tagColumnOperation = tagColumnOperation != null ? tagColumnOperation.build() : null;
            this.handleUnionValueChange(Type.TAG_COLUMN_OPERATION, oldValue, this.tagColumnOperation);
        }

        @Override
        public final Builder tagColumnOperation(TagColumnOperation tagColumnOperation) {
            TagColumnOperation oldValue = this.tagColumnOperation;
            this.tagColumnOperation = tagColumnOperation;
            this.handleUnionValueChange(Type.TAG_COLUMN_OPERATION, oldValue, this.tagColumnOperation);
            return this;
        }

        public final UntagColumnOperation.Builder getUntagColumnOperation() {
            return this.untagColumnOperation != null ? this.untagColumnOperation.toBuilder() : null;
        }

        public final void setUntagColumnOperation(UntagColumnOperation.BuilderImpl untagColumnOperation) {
            UntagColumnOperation oldValue = this.untagColumnOperation;
            this.untagColumnOperation = untagColumnOperation != null ? untagColumnOperation.build() : null;
            this.handleUnionValueChange(Type.UNTAG_COLUMN_OPERATION, oldValue, this.untagColumnOperation);
        }

        @Override
        public final Builder untagColumnOperation(UntagColumnOperation untagColumnOperation) {
            UntagColumnOperation oldValue = this.untagColumnOperation;
            this.untagColumnOperation = untagColumnOperation;
            this.handleUnionValueChange(Type.UNTAG_COLUMN_OPERATION, oldValue, this.untagColumnOperation);
            return this;
        }

        public final OverrideDatasetParameterOperation.Builder getOverrideDatasetParameterOperation() {
            return this.overrideDatasetParameterOperation != null ? this.overrideDatasetParameterOperation.toBuilder() : null;
        }

        public final void setOverrideDatasetParameterOperation(OverrideDatasetParameterOperation.BuilderImpl overrideDatasetParameterOperation) {
            OverrideDatasetParameterOperation oldValue = this.overrideDatasetParameterOperation;
            this.overrideDatasetParameterOperation = overrideDatasetParameterOperation != null ? overrideDatasetParameterOperation.build() : null;
            this.handleUnionValueChange(Type.OVERRIDE_DATASET_PARAMETER_OPERATION, oldValue, this.overrideDatasetParameterOperation);
        }

        @Override
        public final Builder overrideDatasetParameterOperation(OverrideDatasetParameterOperation overrideDatasetParameterOperation) {
            OverrideDatasetParameterOperation oldValue = this.overrideDatasetParameterOperation;
            this.overrideDatasetParameterOperation = overrideDatasetParameterOperation;
            this.handleUnionValueChange(Type.OVERRIDE_DATASET_PARAMETER_OPERATION, oldValue, this.overrideDatasetParameterOperation);
            return this;
        }

        public TransformOperation build() {
            return new TransformOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformOperation> {
        public Builder projectOperation(ProjectOperation var1);

        default public Builder projectOperation(Consumer<ProjectOperation.Builder> projectOperation) {
            return this.projectOperation((ProjectOperation)((ProjectOperation.Builder)ProjectOperation.builder().applyMutation(projectOperation)).build());
        }

        public Builder filterOperation(FilterOperation var1);

        default public Builder filterOperation(Consumer<FilterOperation.Builder> filterOperation) {
            return this.filterOperation((FilterOperation)((FilterOperation.Builder)FilterOperation.builder().applyMutation(filterOperation)).build());
        }

        public Builder createColumnsOperation(CreateColumnsOperation var1);

        default public Builder createColumnsOperation(Consumer<CreateColumnsOperation.Builder> createColumnsOperation) {
            return this.createColumnsOperation((CreateColumnsOperation)((CreateColumnsOperation.Builder)CreateColumnsOperation.builder().applyMutation(createColumnsOperation)).build());
        }

        public Builder renameColumnOperation(RenameColumnOperation var1);

        default public Builder renameColumnOperation(Consumer<RenameColumnOperation.Builder> renameColumnOperation) {
            return this.renameColumnOperation((RenameColumnOperation)((RenameColumnOperation.Builder)RenameColumnOperation.builder().applyMutation(renameColumnOperation)).build());
        }

        public Builder castColumnTypeOperation(CastColumnTypeOperation var1);

        default public Builder castColumnTypeOperation(Consumer<CastColumnTypeOperation.Builder> castColumnTypeOperation) {
            return this.castColumnTypeOperation((CastColumnTypeOperation)((CastColumnTypeOperation.Builder)CastColumnTypeOperation.builder().applyMutation(castColumnTypeOperation)).build());
        }

        public Builder tagColumnOperation(TagColumnOperation var1);

        default public Builder tagColumnOperation(Consumer<TagColumnOperation.Builder> tagColumnOperation) {
            return this.tagColumnOperation((TagColumnOperation)((TagColumnOperation.Builder)TagColumnOperation.builder().applyMutation(tagColumnOperation)).build());
        }

        public Builder untagColumnOperation(UntagColumnOperation var1);

        default public Builder untagColumnOperation(Consumer<UntagColumnOperation.Builder> untagColumnOperation) {
            return this.untagColumnOperation((UntagColumnOperation)((UntagColumnOperation.Builder)UntagColumnOperation.builder().applyMutation(untagColumnOperation)).build());
        }

        public Builder overrideDatasetParameterOperation(OverrideDatasetParameterOperation var1);

        default public Builder overrideDatasetParameterOperation(Consumer<OverrideDatasetParameterOperation.Builder> overrideDatasetParameterOperation) {
            return this.overrideDatasetParameterOperation((OverrideDatasetParameterOperation)((OverrideDatasetParameterOperation.Builder)OverrideDatasetParameterOperation.builder().applyMutation(overrideDatasetParameterOperation)).build());
        }
    }
}

