/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.PaginationConfiguration;
import software.amazon.awssdk.services.quicksight.model.RowSortListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> ROW_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RowSort").getter(TableSortConfiguration.getter(TableSortConfiguration::rowSort)).setter(TableSortConfiguration.setter(Builder::rowSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PaginationConfiguration> PAGINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PaginationConfiguration").getter(TableSortConfiguration.getter(TableSortConfiguration::paginationConfiguration)).setter(TableSortConfiguration.setter(Builder::paginationConfiguration)).constructor(PaginationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_SORT_FIELD, PAGINATION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> rowSort;
    private final PaginationConfiguration paginationConfiguration;

    private TableSortConfiguration(BuilderImpl builder) {
        this.rowSort = builder.rowSort;
        this.paginationConfiguration = builder.paginationConfiguration;
    }

    public final boolean hasRowSort() {
        return this.rowSort != null && !(this.rowSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> rowSort() {
        return this.rowSort;
    }

    public final PaginationConfiguration paginationConfiguration() {
        return this.paginationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowSort() ? this.rowSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableSortConfiguration)) {
            return false;
        }
        TableSortConfiguration other = (TableSortConfiguration)obj;
        return this.hasRowSort() == other.hasRowSort() && Objects.equals(this.rowSort(), other.rowSort()) && Objects.equals(this.paginationConfiguration(), other.paginationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TableSortConfiguration").add("RowSort", this.hasRowSort() ? this.rowSort() : null).add("PaginationConfiguration", (Object)this.paginationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RowSort": {
                return Optional.ofNullable(clazz.cast(this.rowSort()));
            }
            case "PaginationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.paginationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableSortConfiguration, T> g) {
        return obj -> g.apply((TableSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> rowSort = DefaultSdkAutoConstructList.getInstance();
        private PaginationConfiguration paginationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TableSortConfiguration model) {
            this.rowSort(model.rowSort);
            this.paginationConfiguration(model.paginationConfiguration);
        }

        public final List<FieldSortOptions.Builder> getRowSort() {
            List<FieldSortOptions.Builder> result = RowSortListCopier.copyToBuilder(this.rowSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowSort(Collection<FieldSortOptions.BuilderImpl> rowSort) {
            this.rowSort = RowSortListCopier.copyFromBuilder(rowSort);
        }

        @Override
        public final Builder rowSort(Collection<FieldSortOptions> rowSort) {
            this.rowSort = RowSortListCopier.copy(rowSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(FieldSortOptions ... rowSort) {
            this.rowSort(Arrays.asList(rowSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(Consumer<FieldSortOptions.Builder> ... rowSort) {
            this.rowSort(Stream.of(rowSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PaginationConfiguration.Builder getPaginationConfiguration() {
            return this.paginationConfiguration != null ? this.paginationConfiguration.toBuilder() : null;
        }

        public final void setPaginationConfiguration(PaginationConfiguration.BuilderImpl paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration != null ? paginationConfiguration.build() : null;
        }

        @Override
        public final Builder paginationConfiguration(PaginationConfiguration paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration;
            return this;
        }

        public TableSortConfiguration build() {
            return new TableSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableSortConfiguration> {
        public Builder rowSort(Collection<FieldSortOptions> var1);

        public Builder rowSort(FieldSortOptions ... var1);

        public Builder rowSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder paginationConfiguration(PaginationConfiguration var1);

        default public Builder paginationConfiguration(Consumer<PaginationConfiguration.Builder> paginationConfiguration) {
            return this.paginationConfiguration((PaginationConfiguration)((PaginationConfiguration.Builder)PaginationConfiguration.builder().applyMutation(paginationConfiguration)).build());
        }
    }
}

