/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataPathType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPathValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPathValue> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(DataPathValue.getter(DataPathValue::fieldId)).setter(DataPathValue.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldValue").getter(DataPathValue.getter(DataPathValue::fieldValue)).setter(DataPathValue.setter(Builder::fieldValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()}).build();
    private static final SdkField<DataPathType> DATA_PATH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPathType").getter(DataPathValue.getter(DataPathValue::dataPathType)).setter(DataPathValue.setter(Builder::dataPathType)).constructor(DataPathType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPathType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, FIELD_VALUE_FIELD, DATA_PATH_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String fieldValue;
    private final DataPathType dataPathType;

    private DataPathValue(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.fieldValue = builder.fieldValue;
        this.dataPathType = builder.dataPathType;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String fieldValue() {
        return this.fieldValue;
    }

    public final DataPathType dataPathType() {
        return this.dataPathType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPathType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathValue)) {
            return false;
        }
        DataPathValue other = (DataPathValue)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.fieldValue(), other.fieldValue()) && Objects.equals(this.dataPathType(), other.dataPathType());
    }

    public final String toString() {
        return ToString.builder((String)"DataPathValue").add("FieldId", (Object)this.fieldId()).add("FieldValue", (Object)(this.fieldValue() == null ? null : "*** Sensitive Data Redacted ***")).add("DataPathType", (Object)this.dataPathType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "FieldValue": {
                return Optional.ofNullable(clazz.cast(this.fieldValue()));
            }
            case "DataPathType": {
                return Optional.ofNullable(clazz.cast(this.dataPathType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPathValue, T> g) {
        return obj -> g.apply((DataPathValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String fieldValue;
        private DataPathType dataPathType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathValue model) {
            this.fieldId(model.fieldId);
            this.fieldValue(model.fieldValue);
            this.dataPathType(model.dataPathType);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getFieldValue() {
            return this.fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public final DataPathType.Builder getDataPathType() {
            return this.dataPathType != null ? this.dataPathType.toBuilder() : null;
        }

        public final void setDataPathType(DataPathType.BuilderImpl dataPathType) {
            this.dataPathType = dataPathType != null ? dataPathType.build() : null;
        }

        @Override
        public final Builder dataPathType(DataPathType dataPathType) {
            this.dataPathType = dataPathType;
            return this;
        }

        public DataPathValue build() {
            return new DataPathValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPathValue> {
        public Builder fieldId(String var1);

        public Builder fieldValue(String var1);

        public Builder dataPathType(DataPathType var1);

        default public Builder dataPathType(Consumer<DataPathType.Builder> dataPathType) {
            return this.dataPathType((DataPathType)((DataPathType.Builder)DataPathType.builder().applyMutation(dataPathType)).build());
        }
    }
}

