/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ComparisonFormatConfiguration;
import software.amazon.awssdk.services.quicksight.model.ComparisonMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComparisonConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComparisonConfiguration> {
    private static final SdkField<String> COMPARISON_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonMethod").getter(ComparisonConfiguration.getter(ComparisonConfiguration::comparisonMethodAsString)).setter(ComparisonConfiguration.setter(Builder::comparisonMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonMethod").build()}).build();
    private static final SdkField<ComparisonFormatConfiguration> COMPARISON_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComparisonFormat").getter(ComparisonConfiguration.getter(ComparisonConfiguration::comparisonFormat)).setter(ComparisonConfiguration.setter(Builder::comparisonFormat)).constructor(ComparisonFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_METHOD_FIELD, COMPARISON_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparisonMethod;
    private final ComparisonFormatConfiguration comparisonFormat;

    private ComparisonConfiguration(BuilderImpl builder) {
        this.comparisonMethod = builder.comparisonMethod;
        this.comparisonFormat = builder.comparisonFormat;
    }

    public final ComparisonMethod comparisonMethod() {
        return ComparisonMethod.fromValue(this.comparisonMethod);
    }

    public final String comparisonMethodAsString() {
        return this.comparisonMethod;
    }

    public final ComparisonFormatConfiguration comparisonFormat() {
        return this.comparisonFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparisonConfiguration)) {
            return false;
        }
        ComparisonConfiguration other = (ComparisonConfiguration)obj;
        return Objects.equals(this.comparisonMethodAsString(), other.comparisonMethodAsString()) && Objects.equals(this.comparisonFormat(), other.comparisonFormat());
    }

    public final String toString() {
        return ToString.builder((String)"ComparisonConfiguration").add("ComparisonMethod", (Object)this.comparisonMethodAsString()).add("ComparisonFormat", (Object)this.comparisonFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComparisonMethod": {
                return Optional.ofNullable(clazz.cast(this.comparisonMethodAsString()));
            }
            case "ComparisonFormat": {
                return Optional.ofNullable(clazz.cast(this.comparisonFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComparisonConfiguration, T> g) {
        return obj -> g.apply((ComparisonConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparisonMethod;
        private ComparisonFormatConfiguration comparisonFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparisonConfiguration model) {
            this.comparisonMethod(model.comparisonMethod);
            this.comparisonFormat(model.comparisonFormat);
        }

        public final String getComparisonMethod() {
            return this.comparisonMethod;
        }

        public final void setComparisonMethod(String comparisonMethod) {
            this.comparisonMethod = comparisonMethod;
        }

        @Override
        public final Builder comparisonMethod(String comparisonMethod) {
            this.comparisonMethod = comparisonMethod;
            return this;
        }

        @Override
        public final Builder comparisonMethod(ComparisonMethod comparisonMethod) {
            this.comparisonMethod(comparisonMethod == null ? null : comparisonMethod.toString());
            return this;
        }

        public final ComparisonFormatConfiguration.Builder getComparisonFormat() {
            return this.comparisonFormat != null ? this.comparisonFormat.toBuilder() : null;
        }

        public final void setComparisonFormat(ComparisonFormatConfiguration.BuilderImpl comparisonFormat) {
            this.comparisonFormat = comparisonFormat != null ? comparisonFormat.build() : null;
        }

        @Override
        public final Builder comparisonFormat(ComparisonFormatConfiguration comparisonFormat) {
            this.comparisonFormat = comparisonFormat;
            return this;
        }

        public ComparisonConfiguration build() {
            return new ComparisonConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComparisonConfiguration> {
        public Builder comparisonMethod(String var1);

        public Builder comparisonMethod(ComparisonMethod var1);

        public Builder comparisonFormat(ComparisonFormatConfiguration var1);

        default public Builder comparisonFormat(Consumer<ComparisonFormatConfiguration.Builder> comparisonFormat) {
            return this.comparisonFormat((ComparisonFormatConfiguration)((ComparisonFormatConfiguration.Builder)ComparisonFormatConfiguration.builder().applyMutation(comparisonFormat)).build());
        }
    }
}

