/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a named entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicNamedEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicNamedEntity.Builder, TopicNamedEntity> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityName").getter(getter(TopicNamedEntity::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()).build();

    private static final SdkField<String> ENTITY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityDescription").getter(getter(TopicNamedEntity::entityDescription))
            .setter(setter(Builder::entityDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDescription").build()).build();

    private static final SdkField<List<String>> ENTITY_SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EntitySynonyms")
            .getter(getter(TopicNamedEntity::entitySynonyms))
            .setter(setter(Builder::entitySynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitySynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SemanticEntityType> SEMANTIC_ENTITY_TYPE_FIELD = SdkField
            .<SemanticEntityType> builder(MarshallingType.SDK_POJO).memberName("SemanticEntityType")
            .getter(getter(TopicNamedEntity::semanticEntityType)).setter(setter(Builder::semanticEntityType))
            .constructor(SemanticEntityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticEntityType").build())
            .build();

    private static final SdkField<List<NamedEntityDefinition>> DEFINITION_FIELD = SdkField
            .<List<NamedEntityDefinition>> builder(MarshallingType.LIST)
            .memberName("Definition")
            .getter(getter(TopicNamedEntity::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NamedEntityDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(NamedEntityDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD,
            ENTITY_DESCRIPTION_FIELD, ENTITY_SYNONYMS_FIELD, SEMANTIC_ENTITY_TYPE_FIELD, DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityName;

    private final String entityDescription;

    private final List<String> entitySynonyms;

    private final SemanticEntityType semanticEntityType;

    private final List<NamedEntityDefinition> definition;

    private TopicNamedEntity(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.entityDescription = builder.entityDescription;
        this.entitySynonyms = builder.entitySynonyms;
        this.semanticEntityType = builder.semanticEntityType;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The name of the named entity.
     * </p>
     * 
     * @return The name of the named entity.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * The description of the named entity.
     * </p>
     * 
     * @return The description of the named entity.
     */
    public final String entityDescription() {
        return entityDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntitySynonyms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitySynonyms() {
        return entitySynonyms != null && !(entitySynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the named entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitySynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the named entity.
     */
    public final List<String> entitySynonyms() {
        return entitySynonyms;
    }

    /**
     * <p>
     * The type of named entity that a topic represents.
     * </p>
     * 
     * @return The type of named entity that a topic represents.
     */
    public final SemanticEntityType semanticEntityType() {
        return semanticEntityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Definition property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDefinition() {
        return definition != null && !(definition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of a named entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefinition} method.
     * </p>
     * 
     * @return The definition of a named entity.
     */
    public final List<NamedEntityDefinition> definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(entityDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitySynonyms() ? entitySynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(semanticEntityType());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefinition() ? definition() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNamedEntity)) {
            return false;
        }
        TopicNamedEntity other = (TopicNamedEntity) obj;
        return Objects.equals(entityName(), other.entityName()) && Objects.equals(entityDescription(), other.entityDescription())
                && hasEntitySynonyms() == other.hasEntitySynonyms() && Objects.equals(entitySynonyms(), other.entitySynonyms())
                && Objects.equals(semanticEntityType(), other.semanticEntityType()) && hasDefinition() == other.hasDefinition()
                && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicNamedEntity").add("EntityName", entityName()).add("EntityDescription", entityDescription())
                .add("EntitySynonyms", hasEntitySynonyms() ? entitySynonyms() : null)
                .add("SemanticEntityType", semanticEntityType()).add("Definition", hasDefinition() ? definition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "EntityDescription":
            return Optional.ofNullable(clazz.cast(entityDescription()));
        case "EntitySynonyms":
            return Optional.ofNullable(clazz.cast(entitySynonyms()));
        case "SemanticEntityType":
            return Optional.ofNullable(clazz.cast(semanticEntityType()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicNamedEntity, T> g) {
        return obj -> g.apply((TopicNamedEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicNamedEntity> {
        /**
         * <p>
         * The name of the named entity.
         * </p>
         * 
         * @param entityName
         *        The name of the named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * The description of the named entity.
         * </p>
         * 
         * @param entityDescription
         *        The description of the named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityDescription(String entityDescription);

        /**
         * <p>
         * The other names or aliases for the named entity.
         * </p>
         * 
         * @param entitySynonyms
         *        The other names or aliases for the named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitySynonyms(Collection<String> entitySynonyms);

        /**
         * <p>
         * The other names or aliases for the named entity.
         * </p>
         * 
         * @param entitySynonyms
         *        The other names or aliases for the named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitySynonyms(String... entitySynonyms);

        /**
         * <p>
         * The type of named entity that a topic represents.
         * </p>
         * 
         * @param semanticEntityType
         *        The type of named entity that a topic represents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticEntityType(SemanticEntityType semanticEntityType);

        /**
         * <p>
         * The type of named entity that a topic represents.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemanticEntityType.Builder} avoiding the
         * need to create one manually via {@link SemanticEntityType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticEntityType.Builder#build()} is called immediately and its
         * result is passed to {@link #semanticEntityType(SemanticEntityType)}.
         * 
         * @param semanticEntityType
         *        a consumer that will call methods on {@link SemanticEntityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticEntityType(SemanticEntityType)
         */
        default Builder semanticEntityType(Consumer<SemanticEntityType.Builder> semanticEntityType) {
            return semanticEntityType(SemanticEntityType.builder().applyMutation(semanticEntityType).build());
        }

        /**
         * <p>
         * The definition of a named entity.
         * </p>
         * 
         * @param definition
         *        The definition of a named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Collection<NamedEntityDefinition> definition);

        /**
         * <p>
         * The definition of a named entity.
         * </p>
         * 
         * @param definition
         *        The definition of a named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(NamedEntityDefinition... definition);

        /**
         * <p>
         * The definition of a named entity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.NamedEntityDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.NamedEntityDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.NamedEntityDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #definition(List<NamedEntityDefinition>)}.
         * 
         * @param definition
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.NamedEntityDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(java.util.Collection<NamedEntityDefinition>)
         */
        Builder definition(Consumer<NamedEntityDefinition.Builder>... definition);
    }

    static final class BuilderImpl implements Builder {
        private String entityName;

        private String entityDescription;

        private List<String> entitySynonyms = DefaultSdkAutoConstructList.getInstance();

        private SemanticEntityType semanticEntityType;

        private List<NamedEntityDefinition> definition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicNamedEntity model) {
            entityName(model.entityName);
            entityDescription(model.entityDescription);
            entitySynonyms(model.entitySynonyms);
            semanticEntityType(model.semanticEntityType);
            definition(model.definition);
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getEntityDescription() {
            return entityDescription;
        }

        public final void setEntityDescription(String entityDescription) {
            this.entityDescription = entityDescription;
        }

        @Override
        public final Builder entityDescription(String entityDescription) {
            this.entityDescription = entityDescription;
            return this;
        }

        public final Collection<String> getEntitySynonyms() {
            if (entitySynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return entitySynonyms;
        }

        public final void setEntitySynonyms(Collection<String> entitySynonyms) {
            this.entitySynonyms = SynonymsCopier.copy(entitySynonyms);
        }

        @Override
        public final Builder entitySynonyms(Collection<String> entitySynonyms) {
            this.entitySynonyms = SynonymsCopier.copy(entitySynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitySynonyms(String... entitySynonyms) {
            entitySynonyms(Arrays.asList(entitySynonyms));
            return this;
        }

        public final SemanticEntityType.Builder getSemanticEntityType() {
            return semanticEntityType != null ? semanticEntityType.toBuilder() : null;
        }

        public final void setSemanticEntityType(SemanticEntityType.BuilderImpl semanticEntityType) {
            this.semanticEntityType = semanticEntityType != null ? semanticEntityType.build() : null;
        }

        @Override
        public final Builder semanticEntityType(SemanticEntityType semanticEntityType) {
            this.semanticEntityType = semanticEntityType;
            return this;
        }

        public final List<NamedEntityDefinition.Builder> getDefinition() {
            List<NamedEntityDefinition.Builder> result = NamedEntityDefinitionsCopier.copyToBuilder(this.definition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefinition(Collection<NamedEntityDefinition.BuilderImpl> definition) {
            this.definition = NamedEntityDefinitionsCopier.copyFromBuilder(definition);
        }

        @Override
        public final Builder definition(Collection<NamedEntityDefinition> definition) {
            this.definition = NamedEntityDefinitionsCopier.copy(definition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definition(NamedEntityDefinition... definition) {
            definition(Arrays.asList(definition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definition(Consumer<NamedEntityDefinition.Builder>... definition) {
            definition(Stream.of(definition).map(c -> NamedEntityDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TopicNamedEntity build() {
            return new TopicNamedEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
