/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information on the Amazon S3 destinations of the generated snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotDestinationConfiguration.Builder, SnapshotDestinationConfiguration> {
    private static final SdkField<List<SnapshotS3DestinationConfiguration>> S3_DESTINATIONS_FIELD = SdkField
            .<List<SnapshotS3DestinationConfiguration>> builder(MarshallingType.LIST)
            .memberName("S3Destinations")
            .getter(getter(SnapshotDestinationConfiguration::s3Destinations))
            .setter(setter(Builder::s3Destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotS3DestinationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotS3DestinationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DESTINATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SnapshotS3DestinationConfiguration> s3Destinations;

    private SnapshotDestinationConfiguration(BuilderImpl builder) {
        this.s3Destinations = builder.s3Destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3Destinations() {
        return s3Destinations != null && !(s3Destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
     * configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Destinations} method.
     * </p>
     * 
     * @return A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
     *         configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
     */
    public final List<SnapshotS3DestinationConfiguration> s3Destinations() {
        return s3Destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Destinations() ? s3Destinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDestinationConfiguration)) {
            return false;
        }
        SnapshotDestinationConfiguration other = (SnapshotDestinationConfiguration) obj;
        return hasS3Destinations() == other.hasS3Destinations() && Objects.equals(s3Destinations(), other.s3Destinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotDestinationConfiguration")
                .add("S3Destinations", hasS3Destinations() ? s3Destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Destinations":
            return Optional.ofNullable(clazz.cast(s3Destinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDestinationConfiguration, T> g) {
        return obj -> g.apply((SnapshotDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotDestinationConfiguration> {
        /**
         * <p>
         * A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
         * configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
         * </p>
         * 
         * @param s3Destinations
         *        A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
         *        configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destinations(Collection<SnapshotS3DestinationConfiguration> s3Destinations);

        /**
         * <p>
         * A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
         * configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
         * </p>
         * 
         * @param s3Destinations
         *        A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
         *        configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destinations(SnapshotS3DestinationConfiguration... s3Destinations);

        /**
         * <p>
         * A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination
         * configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotS3DestinationConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotS3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotS3DestinationConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #s3Destinations(List<SnapshotS3DestinationConfiguration>)}.
         * 
         * @param s3Destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotS3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destinations(java.util.Collection<SnapshotS3DestinationConfiguration>)
         */
        Builder s3Destinations(Consumer<SnapshotS3DestinationConfiguration.Builder>... s3Destinations);
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotS3DestinationConfiguration> s3Destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDestinationConfiguration model) {
            s3Destinations(model.s3Destinations);
        }

        public final List<SnapshotS3DestinationConfiguration.Builder> getS3Destinations() {
            List<SnapshotS3DestinationConfiguration.Builder> result = SnapshotS3DestinationConfigurationListCopier
                    .copyToBuilder(this.s3Destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Destinations(Collection<SnapshotS3DestinationConfiguration.BuilderImpl> s3Destinations) {
            this.s3Destinations = SnapshotS3DestinationConfigurationListCopier.copyFromBuilder(s3Destinations);
        }

        @Override
        public final Builder s3Destinations(Collection<SnapshotS3DestinationConfiguration> s3Destinations) {
            this.s3Destinations = SnapshotS3DestinationConfigurationListCopier.copy(s3Destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Destinations(SnapshotS3DestinationConfiguration... s3Destinations) {
            s3Destinations(Arrays.asList(s3Destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Destinations(Consumer<SnapshotS3DestinationConfiguration.Builder>... s3Destinations) {
            s3Destinations(Stream.of(s3Destinations)
                    .map(c -> SnapshotS3DestinationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotDestinationConfiguration build() {
            return new SnapshotDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
