/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>Layout</code> defines the placement of elements within a sheet.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of
 * layout</a> in the <i>Amazon QuickSight User Guide</i>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Layout implements SdkPojo, Serializable, ToCopyableBuilder<Layout.Builder, Layout> {
    private static final SdkField<LayoutConfiguration> CONFIGURATION_FIELD = SdkField
            .<LayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(Layout::configuration)).setter(setter(Builder::configuration))
            .constructor(LayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final LayoutConfiguration configuration;

    private Layout(BuilderImpl builder) {
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The configuration that determines what the type of layout for a sheet.
     * </p>
     * 
     * @return The configuration that determines what the type of layout for a sheet.
     */
    public final LayoutConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layout)) {
            return false;
        }
        Layout other = (Layout) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Layout").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Layout, T> g) {
        return obj -> g.apply((Layout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Layout> {
        /**
         * <p>
         * The configuration that determines what the type of layout for a sheet.
         * </p>
         * 
         * @param configuration
         *        The configuration that determines what the type of layout for a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(LayoutConfiguration configuration);

        /**
         * <p>
         * The configuration that determines what the type of layout for a sheet.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutConfiguration.Builder} avoiding the
         * need to create one manually via {@link LayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(LayoutConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link LayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(LayoutConfiguration)
         */
        default Builder configuration(Consumer<LayoutConfiguration.Builder> configuration) {
            return configuration(LayoutConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LayoutConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(Layout model) {
            configuration(model.configuration);
        }

        public final LayoutConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(LayoutConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(LayoutConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Layout build() {
            return new Layout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
