/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the color scale that is applied to the visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColorScale implements SdkPojo, Serializable, ToCopyableBuilder<ColorScale.Builder, ColorScale> {
    private static final SdkField<List<DataColor>> COLORS_FIELD = SdkField
            .<List<DataColor>> builder(MarshallingType.LIST)
            .memberName("Colors")
            .getter(getter(ColorScale::colors))
            .setter(setter(Builder::colors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataColor> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataColor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COLOR_FILL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorFillType").getter(getter(ColorScale::colorFillTypeAsString)).setter(setter(Builder::colorFillType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorFillType").build()).build();

    private static final SdkField<DataColor> NULL_VALUE_COLOR_FIELD = SdkField.<DataColor> builder(MarshallingType.SDK_POJO)
            .memberName("NullValueColor").getter(getter(ColorScale::nullValueColor)).setter(setter(Builder::nullValueColor))
            .constructor(DataColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValueColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLORS_FIELD,
            COLOR_FILL_TYPE_FIELD, NULL_VALUE_COLOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataColor> colors;

    private final String colorFillType;

    private final DataColor nullValueColor;

    private ColorScale(BuilderImpl builder) {
        this.colors = builder.colors;
        this.colorFillType = builder.colorFillType;
        this.nullValueColor = builder.nullValueColor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Colors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColors() {
        return colors != null && !(colors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the list of colors that are applied to the visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColors} method.
     * </p>
     * 
     * @return Determines the list of colors that are applied to the visual.
     */
    public final List<DataColor> colors() {
        return colors;
    }

    /**
     * <p>
     * Determines the color fill type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorFillType}
     * will return {@link ColorFillType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorFillTypeAsString}.
     * </p>
     * 
     * @return Determines the color fill type.
     * @see ColorFillType
     */
    public final ColorFillType colorFillType() {
        return ColorFillType.fromValue(colorFillType);
    }

    /**
     * <p>
     * Determines the color fill type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorFillType}
     * will return {@link ColorFillType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorFillTypeAsString}.
     * </p>
     * 
     * @return Determines the color fill type.
     * @see ColorFillType
     */
    public final String colorFillTypeAsString() {
        return colorFillType;
    }

    /**
     * <p>
     * Determines the color that is applied to null values.
     * </p>
     * 
     * @return Determines the color that is applied to null values.
     */
    public final DataColor nullValueColor() {
        return nullValueColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColors() ? colors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(colorFillTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nullValueColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorScale)) {
            return false;
        }
        ColorScale other = (ColorScale) obj;
        return hasColors() == other.hasColors() && Objects.equals(colors(), other.colors())
                && Objects.equals(colorFillTypeAsString(), other.colorFillTypeAsString())
                && Objects.equals(nullValueColor(), other.nullValueColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColorScale").add("Colors", hasColors() ? colors() : null)
                .add("ColorFillType", colorFillTypeAsString()).add("NullValueColor", nullValueColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Colors":
            return Optional.ofNullable(clazz.cast(colors()));
        case "ColorFillType":
            return Optional.ofNullable(clazz.cast(colorFillTypeAsString()));
        case "NullValueColor":
            return Optional.ofNullable(clazz.cast(nullValueColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColorScale, T> g) {
        return obj -> g.apply((ColorScale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColorScale> {
        /**
         * <p>
         * Determines the list of colors that are applied to the visual.
         * </p>
         * 
         * @param colors
         *        Determines the list of colors that are applied to the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(Collection<DataColor> colors);

        /**
         * <p>
         * Determines the list of colors that are applied to the visual.
         * </p>
         * 
         * @param colors
         *        Determines the list of colors that are applied to the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(DataColor... colors);

        /**
         * <p>
         * Determines the list of colors that are applied to the visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataColor.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.DataColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataColor.Builder#build()} is called immediately and
         * its result is passed to {@link #colors(List<DataColor>)}.
         * 
         * @param colors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colors(java.util.Collection<DataColor>)
         */
        Builder colors(Consumer<DataColor.Builder>... colors);

        /**
         * <p>
         * Determines the color fill type.
         * </p>
         * 
         * @param colorFillType
         *        Determines the color fill type.
         * @see ColorFillType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorFillType
         */
        Builder colorFillType(String colorFillType);

        /**
         * <p>
         * Determines the color fill type.
         * </p>
         * 
         * @param colorFillType
         *        Determines the color fill type.
         * @see ColorFillType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorFillType
         */
        Builder colorFillType(ColorFillType colorFillType);

        /**
         * <p>
         * Determines the color that is applied to null values.
         * </p>
         * 
         * @param nullValueColor
         *        Determines the color that is applied to null values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullValueColor(DataColor nullValueColor);

        /**
         * <p>
         * Determines the color that is applied to null values.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataColor.Builder} avoiding the need to
         * create one manually via {@link DataColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataColor.Builder#build()} is called immediately and its result
         * is passed to {@link #nullValueColor(DataColor)}.
         * 
         * @param nullValueColor
         *        a consumer that will call methods on {@link DataColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullValueColor(DataColor)
         */
        default Builder nullValueColor(Consumer<DataColor.Builder> nullValueColor) {
            return nullValueColor(DataColor.builder().applyMutation(nullValueColor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<DataColor> colors = DefaultSdkAutoConstructList.getInstance();

        private String colorFillType;

        private DataColor nullValueColor;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorScale model) {
            colors(model.colors);
            colorFillType(model.colorFillType);
            nullValueColor(model.nullValueColor);
        }

        public final List<DataColor.Builder> getColors() {
            List<DataColor.Builder> result = ColorScaleColorListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<DataColor.BuilderImpl> colors) {
            this.colors = ColorScaleColorListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<DataColor> colors) {
            this.colors = ColorScaleColorListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(DataColor... colors) {
            colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<DataColor.Builder>... colors) {
            colors(Stream.of(colors).map(c -> DataColor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getColorFillType() {
            return colorFillType;
        }

        public final void setColorFillType(String colorFillType) {
            this.colorFillType = colorFillType;
        }

        @Override
        public final Builder colorFillType(String colorFillType) {
            this.colorFillType = colorFillType;
            return this;
        }

        @Override
        public final Builder colorFillType(ColorFillType colorFillType) {
            this.colorFillType(colorFillType == null ? null : colorFillType.toString());
            return this;
        }

        public final DataColor.Builder getNullValueColor() {
            return nullValueColor != null ? nullValueColor.toBuilder() : null;
        }

        public final void setNullValueColor(DataColor.BuilderImpl nullValueColor) {
            this.nullValueColor = nullValueColor != null ? nullValueColor.build() : null;
        }

        @Override
        public final Builder nullValueColor(DataColor nullValueColor) {
            this.nullValueColor = nullValueColor;
            return this;
        }

        @Override
        public ColorScale build() {
            return new ColorScale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
