/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum and maximum setup for an axis display range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisDisplayMinMaxRange implements SdkPojo, Serializable,
        ToCopyableBuilder<AxisDisplayMinMaxRange.Builder, AxisDisplayMinMaxRange> {
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Minimum")
            .getter(getter(AxisDisplayMinMaxRange::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Maximum")
            .getter(getter(AxisDisplayMinMaxRange::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_FIELD, MAXIMUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double minimum;

    private final Double maximum;

    private AxisDisplayMinMaxRange(BuilderImpl builder) {
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    /**
     * <p>
     * The minimum setup for an axis display range.
     * </p>
     * 
     * @return The minimum setup for an axis display range.
     */
    public final Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum setup for an axis display range.
     * </p>
     * 
     * @return The maximum setup for an axis display range.
     */
    public final Double maximum() {
        return maximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisDisplayMinMaxRange)) {
            return false;
        }
        AxisDisplayMinMaxRange other = (AxisDisplayMinMaxRange) obj;
        return Objects.equals(minimum(), other.minimum()) && Objects.equals(maximum(), other.maximum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisDisplayMinMaxRange").add("Minimum", minimum()).add("Maximum", maximum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AxisDisplayMinMaxRange, T> g) {
        return obj -> g.apply((AxisDisplayMinMaxRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisDisplayMinMaxRange> {
        /**
         * <p>
         * The minimum setup for an axis display range.
         * </p>
         * 
         * @param minimum
         *        The minimum setup for an axis display range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The maximum setup for an axis display range.
         * </p>
         * 
         * @param maximum
         *        The maximum setup for an axis display range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);
    }

    static final class BuilderImpl implements Builder {
        private Double minimum;

        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisDisplayMinMaxRange model) {
            minimum(model.minimum);
            maximum(model.maximum);
        }

        public final Double getMinimum() {
            return minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getMaximum() {
            return maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        @Override
        public AxisDisplayMinMaxRange build() {
            return new AxisDisplayMinMaxRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
