/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.qldbsession.DefaultQldbSessionAsyncClient;
import software.amazon.awssdk.services.qldbsession.DefaultQldbSessionBaseClientBuilder;
import software.amazon.awssdk.services.qldbsession.QldbSessionAsyncClient;
import software.amazon.awssdk.services.qldbsession.QldbSessionAsyncClientBuilder;
import software.amazon.awssdk.services.qldbsession.QldbSessionServiceClientConfiguration;
import software.amazon.awssdk.services.qldbsession.endpoints.QldbSessionEndpointProvider;

@SdkInternalApi
final class DefaultQldbSessionAsyncClientBuilder
extends DefaultQldbSessionBaseClientBuilder<QldbSessionAsyncClientBuilder, QldbSessionAsyncClient>
implements QldbSessionAsyncClientBuilder {
    DefaultQldbSessionAsyncClientBuilder() {
    }

    @Override
    public DefaultQldbSessionAsyncClientBuilder endpointProvider(QldbSessionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QldbSessionAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultQldbSessionAsyncClientBuilder.validateClientOptions(clientConfiguration);
        QldbSessionServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultQldbSessionAsyncClient client = new DefaultQldbSessionAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private QldbSessionServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return QldbSessionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

