/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCause {
    KINESIS_STREAM_NOT_FOUND("KINESIS_STREAM_NOT_FOUND"),
    IAM_PERMISSION_REVOKED("IAM_PERMISSION_REVOKED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCause> VALUE_MAP;
    private final String value;

    private ErrorCause(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCause fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCause> knownValues() {
        EnumSet<ErrorCause> knownValues = EnumSet.allOf(ErrorCause.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCause.class, ErrorCause::toString);
    }
}

