/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceSamplePromptsControlMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebExperienceRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateWebExperienceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::applicationId)).setter(UpdateWebExperienceRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<WebExperienceAuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationConfiguration").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::authenticationConfiguration)).setter(UpdateWebExperienceRequest.setter(Builder::authenticationConfiguration)).constructor(WebExperienceAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()}).build();
    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samplePromptsControlMode").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::samplePromptsControlModeAsString)).setter(UpdateWebExperienceRequest.setter(Builder::samplePromptsControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build()}).build();
    private static final SdkField<String> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtitle").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::subtitle)).setter(UpdateWebExperienceRequest.setter(Builder::subtitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::title)).setter(UpdateWebExperienceRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webExperienceId").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::webExperienceId)).setter(UpdateWebExperienceRequest.setter(Builder::webExperienceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("webExperienceId").build()}).build();
    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("welcomeMessage").getter(UpdateWebExperienceRequest.getter(UpdateWebExperienceRequest::welcomeMessage)).setter(UpdateWebExperienceRequest.setter(Builder::welcomeMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD, SUBTITLE_FIELD, TITLE_FIELD, WEB_EXPERIENCE_ID_FIELD, WELCOME_MESSAGE_FIELD));
    private final String applicationId;
    private final WebExperienceAuthConfiguration authenticationConfiguration;
    private final String samplePromptsControlMode;
    private final String subtitle;
    private final String title;
    private final String webExperienceId;
    private final String welcomeMessage;

    private UpdateWebExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.subtitle = builder.subtitle;
        this.title = builder.title;
        this.webExperienceId = builder.webExperienceId;
        this.welcomeMessage = builder.welcomeMessage;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final WebExperienceAuthConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(this.samplePromptsControlMode);
    }

    public final String samplePromptsControlModeAsString() {
        return this.samplePromptsControlMode;
    }

    public final String subtitle() {
        return this.subtitle;
    }

    public final String title() {
        return this.title;
    }

    public final String webExperienceId() {
        return this.webExperienceId;
    }

    public final String welcomeMessage() {
        return this.welcomeMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.webExperienceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.welcomeMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebExperienceRequest)) {
            return false;
        }
        UpdateWebExperienceRequest other = (UpdateWebExperienceRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && Objects.equals(this.samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.webExperienceId(), other.webExperienceId()) && Objects.equals(this.welcomeMessage(), other.welcomeMessage());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWebExperienceRequest").add("ApplicationId", (Object)this.applicationId()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("SamplePromptsControlMode", (Object)this.samplePromptsControlModeAsString()).add("Subtitle", (Object)this.subtitle()).add("Title", (Object)this.title()).add("WebExperienceId", (Object)this.webExperienceId()).add("WelcomeMessage", (Object)this.welcomeMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "samplePromptsControlMode": {
                return Optional.ofNullable(clazz.cast(this.samplePromptsControlModeAsString()));
            }
            case "subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "webExperienceId": {
                return Optional.ofNullable(clazz.cast(this.webExperienceId()));
            }
            case "welcomeMessage": {
                return Optional.ofNullable(clazz.cast(this.welcomeMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebExperienceRequest, T> g) {
        return obj -> g.apply((UpdateWebExperienceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WebExperienceAuthConfiguration authenticationConfiguration;
        private String samplePromptsControlMode;
        private String subtitle;
        private String title;
        private String webExperienceId;
        private String welcomeMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebExperienceRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.samplePromptsControlMode(model.samplePromptsControlMode);
            this.subtitle(model.subtitle);
            this.title(model.title);
            this.webExperienceId(model.webExperienceId);
            this.welcomeMessage(model.welcomeMessage);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final WebExperienceAuthConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(WebExperienceAuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return this.samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final String getSubtitle() {
            return this.subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getWebExperienceId() {
            return this.webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        public final String getWelcomeMessage() {
            return this.welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebExperienceRequest build() {
            return new UpdateWebExperienceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWebExperienceRequest> {
        public Builder applicationId(String var1);

        public Builder authenticationConfiguration(WebExperienceAuthConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<WebExperienceAuthConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((WebExperienceAuthConfiguration)((WebExperienceAuthConfiguration.Builder)WebExperienceAuthConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder samplePromptsControlMode(String var1);

        public Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode var1);

        public Builder subtitle(String var1);

        public Builder title(String var1);

        public Builder webExperienceId(String var1);

        public Builder welcomeMessage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

