/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfigurationsCopier;
import software.amazon.awssdk.services.qbusiness.model.IndexCapacityConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIndexRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateIndexRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateIndexRequest.getter(UpdateIndexRequest::applicationId)).setter(UpdateIndexRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<IndexCapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacityConfiguration").getter(UpdateIndexRequest.getter(UpdateIndexRequest::capacityConfiguration)).setter(UpdateIndexRequest.setter(Builder::capacityConfiguration)).constructor(IndexCapacityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateIndexRequest.getter(UpdateIndexRequest::description)).setter(UpdateIndexRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateIndexRequest.getter(UpdateIndexRequest::displayName)).setter(UpdateIndexRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<DocumentAttributeConfiguration>> DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documentAttributeConfigurations").getter(UpdateIndexRequest.getter(UpdateIndexRequest::documentAttributeConfigurations)).setter(UpdateIndexRequest.setter(Builder::documentAttributeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttributeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(UpdateIndexRequest.getter(UpdateIndexRequest::indexId)).setter(UpdateIndexRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAPACITY_CONFIGURATION_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD, INDEX_ID_FIELD));
    private final String applicationId;
    private final IndexCapacityConfiguration capacityConfiguration;
    private final String description;
    private final String displayName;
    private final List<DocumentAttributeConfiguration> documentAttributeConfigurations;
    private final String indexId;

    private UpdateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.documentAttributeConfigurations = builder.documentAttributeConfigurations;
        this.indexId = builder.indexId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final IndexCapacityConfiguration capacityConfiguration() {
        return this.capacityConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasDocumentAttributeConfigurations() {
        return this.documentAttributeConfigurations != null && !(this.documentAttributeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttributeConfiguration> documentAttributeConfigurations() {
        return this.documentAttributeConfigurations;
    }

    public final String indexId() {
        return this.indexId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributeConfigurations() ? this.documentAttributeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexRequest)) {
            return false;
        }
        UpdateIndexRequest other = (UpdateIndexRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.capacityConfiguration(), other.capacityConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && this.hasDocumentAttributeConfigurations() == other.hasDocumentAttributeConfigurations() && Objects.equals(this.documentAttributeConfigurations(), other.documentAttributeConfigurations()) && Objects.equals(this.indexId(), other.indexId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIndexRequest").add("ApplicationId", (Object)this.applicationId()).add("CapacityConfiguration", (Object)this.capacityConfiguration()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("DocumentAttributeConfigurations", this.hasDocumentAttributeConfigurations() ? this.documentAttributeConfigurations() : null).add("IndexId", (Object)this.indexId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "capacityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capacityConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "documentAttributeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeConfigurations()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexRequest, T> g) {
        return obj -> g.apply((UpdateIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private IndexCapacityConfiguration capacityConfiguration;
        private String description;
        private String displayName;
        private List<DocumentAttributeConfiguration> documentAttributeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String indexId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.capacityConfiguration(model.capacityConfiguration);
            this.description(model.description);
            this.displayName(model.displayName);
            this.documentAttributeConfigurations(model.documentAttributeConfigurations);
            this.indexId(model.indexId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final IndexCapacityConfiguration.Builder getCapacityConfiguration() {
            return this.capacityConfiguration != null ? this.capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(IndexCapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<DocumentAttributeConfiguration.Builder> getDocumentAttributeConfigurations() {
            List<DocumentAttributeConfiguration.Builder> result = DocumentAttributeConfigurationsCopier.copyToBuilder(this.documentAttributeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributeConfigurations(Collection<DocumentAttributeConfiguration.BuilderImpl> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier.copyFromBuilder(documentAttributeConfigurations);
        }

        @Override
        public final Builder documentAttributeConfigurations(Collection<DocumentAttributeConfiguration> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier.copy(documentAttributeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(DocumentAttributeConfiguration ... documentAttributeConfigurations) {
            this.documentAttributeConfigurations(Arrays.asList(documentAttributeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(Consumer<DocumentAttributeConfiguration.Builder> ... documentAttributeConfigurations) {
            this.documentAttributeConfigurations(Stream.of(documentAttributeConfigurations).map(c -> (DocumentAttributeConfiguration)((DocumentAttributeConfiguration.Builder)DocumentAttributeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexRequest build() {
            return new UpdateIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIndexRequest> {
        public Builder applicationId(String var1);

        public Builder capacityConfiguration(IndexCapacityConfiguration var1);

        default public Builder capacityConfiguration(Consumer<IndexCapacityConfiguration.Builder> capacityConfiguration) {
            return this.capacityConfiguration((IndexCapacityConfiguration)((IndexCapacityConfiguration.Builder)IndexCapacityConfiguration.builder().applyMutation(capacityConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder documentAttributeConfigurations(Collection<DocumentAttributeConfiguration> var1);

        public Builder documentAttributeConfigurations(DocumentAttributeConfiguration ... var1);

        public Builder documentAttributeConfigurations(Consumer<DocumentAttributeConfiguration.Builder> ... var1);

        public Builder indexId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

