/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.GroupStatusDetail;
import software.amazon.awssdk.services.qbusiness.model.GroupStatusDetailsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGroupResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetGroupResponse> {
    private static final SdkField<GroupStatusDetail> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GetGroupResponse.getter(GetGroupResponse::status)).setter(GetGroupResponse.setter(Builder::status)).constructor(GroupStatusDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<GroupStatusDetail>> STATUS_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusHistory").getter(GetGroupResponse.getter(GetGroupResponse::statusHistory)).setter(GetGroupResponse.setter(Builder::statusHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusHistory").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupStatusDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_HISTORY_FIELD));
    private final GroupStatusDetail status;
    private final List<GroupStatusDetail> statusHistory;

    private GetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusHistory = builder.statusHistory;
    }

    public final GroupStatusDetail status() {
        return this.status;
    }

    public final boolean hasStatusHistory() {
        return this.statusHistory != null && !(this.statusHistory instanceof SdkAutoConstructList);
    }

    public final List<GroupStatusDetail> statusHistory() {
        return this.statusHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusHistory() ? this.statusHistory() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupResponse)) {
            return false;
        }
        GetGroupResponse other = (GetGroupResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && this.hasStatusHistory() == other.hasStatusHistory() && Objects.equals(this.statusHistory(), other.statusHistory());
    }

    public final String toString() {
        return ToString.builder((String)"GetGroupResponse").add("Status", (Object)this.status()).add("StatusHistory", this.hasStatusHistory() ? this.statusHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "statusHistory": {
                return Optional.ofNullable(clazz.cast(this.statusHistory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupResponse, T> g) {
        return obj -> g.apply((GetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private GroupStatusDetail status;
        private List<GroupStatusDetail> statusHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupResponse model) {
            super(model);
            this.status(model.status);
            this.statusHistory(model.statusHistory);
        }

        public final GroupStatusDetail.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(GroupStatusDetail.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(GroupStatusDetail status) {
            this.status = status;
            return this;
        }

        public final List<GroupStatusDetail.Builder> getStatusHistory() {
            List<GroupStatusDetail.Builder> result = GroupStatusDetailsCopier.copyToBuilder(this.statusHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusHistory(Collection<GroupStatusDetail.BuilderImpl> statusHistory) {
            this.statusHistory = GroupStatusDetailsCopier.copyFromBuilder(statusHistory);
        }

        @Override
        public final Builder statusHistory(Collection<GroupStatusDetail> statusHistory) {
            this.statusHistory = GroupStatusDetailsCopier.copy(statusHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusHistory(GroupStatusDetail ... statusHistory) {
            this.statusHistory(Arrays.asList(statusHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusHistory(Consumer<GroupStatusDetail.Builder> ... statusHistory) {
            this.statusHistory(Stream.of(statusHistory).map(c -> (GroupStatusDetail)((GroupStatusDetail.Builder)GroupStatusDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetGroupResponse build() {
            return new GetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGroupResponse> {
        public Builder status(GroupStatusDetail var1);

        default public Builder status(Consumer<GroupStatusDetail.Builder> status) {
            return this.status((GroupStatusDetail)((GroupStatusDetail.Builder)GroupStatusDetail.builder().applyMutation(status)).build());
        }

        public Builder statusHistory(Collection<GroupStatusDetail> var1);

        public Builder statusHistory(GroupStatusDetail ... var1);

        public Builder statusHistory(Consumer<GroupStatusDetail.Builder> ... var1);
    }
}

