/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.CreateUserRequestUserAliasesListCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.UserAlias;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateUserRequest.getter(CreateUserRequest::applicationId)).setter(CreateUserRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateUserRequest.getter(CreateUserRequest::clientToken)).setter(CreateUserRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<UserAlias>> USER_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAliases").getter(CreateUserRequest.getter(CreateUserRequest::userAliases)).setter(CreateUserRequest.setter(Builder::userAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(CreateUserRequest.getter(CreateUserRequest::userId)).setter(CreateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CLIENT_TOKEN_FIELD, USER_ALIASES_FIELD, USER_ID_FIELD));
    private final String applicationId;
    private final String clientToken;
    private final List<UserAlias> userAliases;
    private final String userId;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.userAliases = builder.userAliases;
        this.userId = builder.userId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasUserAliases() {
        return this.userAliases != null && !(this.userAliases instanceof SdkAutoConstructList);
    }

    public final List<UserAlias> userAliases() {
        return this.userAliases;
    }

    public final String userId() {
        return this.userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAliases() ? this.userAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasUserAliases() == other.hasUserAliases() && Objects.equals(this.userAliases(), other.userAliases()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserRequest").add("ApplicationId", (Object)this.applicationId()).add("ClientToken", (Object)this.clientToken()).add("UserAliases", this.hasUserAliases() ? this.userAliases() : null).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "userAliases": {
                return Optional.ofNullable(clazz.cast(this.userAliases()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String clientToken;
        private List<UserAlias> userAliases = DefaultSdkAutoConstructList.getInstance();
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.clientToken(model.clientToken);
            this.userAliases(model.userAliases);
            this.userId(model.userId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<UserAlias.Builder> getUserAliases() {
            List<UserAlias.Builder> result = CreateUserRequestUserAliasesListCopier.copyToBuilder(this.userAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliases(Collection<UserAlias.BuilderImpl> userAliases) {
            this.userAliases = CreateUserRequestUserAliasesListCopier.copyFromBuilder(userAliases);
        }

        @Override
        public final Builder userAliases(Collection<UserAlias> userAliases) {
            this.userAliases = CreateUserRequestUserAliasesListCopier.copy(userAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(UserAlias ... userAliases) {
            this.userAliases(Arrays.asList(userAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(Consumer<UserAlias.Builder> ... userAliases) {
            this.userAliases(Stream.of(userAliases).map(c -> (UserAlias)((UserAlias.Builder)UserAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder applicationId(String var1);

        public Builder clientToken(String var1);

        public Builder userAliases(Collection<UserAlias> var1);

        public Builder userAliases(UserAlias ... var1);

        public Builder userAliases(Consumer<UserAlias.Builder> ... var1);

        public Builder userId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

