/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionReview;
import software.amazon.awssdk.services.qbusiness.model.AttachmentOutput;
import software.amazon.awssdk.services.qbusiness.model.AttachmentsOutputCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.SourceAttribution;
import software.amazon.awssdk.services.qbusiness.model.SourceAttributionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatSyncResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ChatSyncResponse> {
    private static final SdkField<ActionReview> ACTION_REVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionReview").getter(ChatSyncResponse.getter(ChatSyncResponse::actionReview)).setter(ChatSyncResponse.setter(Builder::actionReview)).constructor(ActionReview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReview").build()}).build();
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(ChatSyncResponse.getter(ChatSyncResponse::conversationId)).setter(ChatSyncResponse.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<List<AttachmentOutput>> FAILED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedAttachments").getter(ChatSyncResponse.getter(ChatSyncResponse::failedAttachments)).setter(ChatSyncResponse.setter(Builder::failedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceAttributions").getter(ChatSyncResponse.getter(ChatSyncResponse::sourceAttributions)).setter(ChatSyncResponse.setter(Builder::sourceAttributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAttribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessage").getter(ChatSyncResponse.getter(ChatSyncResponse::systemMessage)).setter(ChatSyncResponse.setter(Builder::systemMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessage").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageId").getter(ChatSyncResponse.getter(ChatSyncResponse::systemMessageId)).setter(ChatSyncResponse.setter(Builder::systemMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()}).build();
    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userMessageId").getter(ChatSyncResponse.getter(ChatSyncResponse::userMessageId)).setter(ChatSyncResponse.setter(Builder::userMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_REVIEW_FIELD, CONVERSATION_ID_FIELD, FAILED_ATTACHMENTS_FIELD, SOURCE_ATTRIBUTIONS_FIELD, SYSTEM_MESSAGE_FIELD, SYSTEM_MESSAGE_ID_FIELD, USER_MESSAGE_ID_FIELD));
    private final ActionReview actionReview;
    private final String conversationId;
    private final List<AttachmentOutput> failedAttachments;
    private final List<SourceAttribution> sourceAttributions;
    private final String systemMessage;
    private final String systemMessageId;
    private final String userMessageId;

    private ChatSyncResponse(BuilderImpl builder) {
        super(builder);
        this.actionReview = builder.actionReview;
        this.conversationId = builder.conversationId;
        this.failedAttachments = builder.failedAttachments;
        this.sourceAttributions = builder.sourceAttributions;
        this.systemMessage = builder.systemMessage;
        this.systemMessageId = builder.systemMessageId;
        this.userMessageId = builder.userMessageId;
    }

    public final ActionReview actionReview() {
        return this.actionReview;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final boolean hasFailedAttachments() {
        return this.failedAttachments != null && !(this.failedAttachments instanceof SdkAutoConstructList);
    }

    public final List<AttachmentOutput> failedAttachments() {
        return this.failedAttachments;
    }

    public final boolean hasSourceAttributions() {
        return this.sourceAttributions != null && !(this.sourceAttributions instanceof SdkAutoConstructList);
    }

    public final List<SourceAttribution> sourceAttributions() {
        return this.sourceAttributions;
    }

    public final String systemMessage() {
        return this.systemMessage;
    }

    public final String systemMessageId() {
        return this.systemMessageId;
    }

    public final String userMessageId() {
        return this.userMessageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionReview());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAttachments() ? this.failedAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAttributions() ? this.sourceAttributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMessageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatSyncResponse)) {
            return false;
        }
        ChatSyncResponse other = (ChatSyncResponse)((Object)obj);
        return Objects.equals(this.actionReview(), other.actionReview()) && Objects.equals(this.conversationId(), other.conversationId()) && this.hasFailedAttachments() == other.hasFailedAttachments() && Objects.equals(this.failedAttachments(), other.failedAttachments()) && this.hasSourceAttributions() == other.hasSourceAttributions() && Objects.equals(this.sourceAttributions(), other.sourceAttributions()) && Objects.equals(this.systemMessage(), other.systemMessage()) && Objects.equals(this.systemMessageId(), other.systemMessageId()) && Objects.equals(this.userMessageId(), other.userMessageId());
    }

    public final String toString() {
        return ToString.builder((String)"ChatSyncResponse").add("ActionReview", (Object)this.actionReview()).add("ConversationId", (Object)this.conversationId()).add("FailedAttachments", this.hasFailedAttachments() ? this.failedAttachments() : null).add("SourceAttributions", this.hasSourceAttributions() ? this.sourceAttributions() : null).add("SystemMessage", (Object)this.systemMessage()).add("SystemMessageId", (Object)this.systemMessageId()).add("UserMessageId", (Object)this.userMessageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionReview": {
                return Optional.ofNullable(clazz.cast(this.actionReview()));
            }
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "failedAttachments": {
                return Optional.ofNullable(clazz.cast(this.failedAttachments()));
            }
            case "sourceAttributions": {
                return Optional.ofNullable(clazz.cast(this.sourceAttributions()));
            }
            case "systemMessage": {
                return Optional.ofNullable(clazz.cast(this.systemMessage()));
            }
            case "systemMessageId": {
                return Optional.ofNullable(clazz.cast(this.systemMessageId()));
            }
            case "userMessageId": {
                return Optional.ofNullable(clazz.cast(this.userMessageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChatSyncResponse, T> g) {
        return obj -> g.apply((ChatSyncResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private ActionReview actionReview;
        private String conversationId;
        private List<AttachmentOutput> failedAttachments = DefaultSdkAutoConstructList.getInstance();
        private List<SourceAttribution> sourceAttributions = DefaultSdkAutoConstructList.getInstance();
        private String systemMessage;
        private String systemMessageId;
        private String userMessageId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatSyncResponse model) {
            super(model);
            this.actionReview(model.actionReview);
            this.conversationId(model.conversationId);
            this.failedAttachments(model.failedAttachments);
            this.sourceAttributions(model.sourceAttributions);
            this.systemMessage(model.systemMessage);
            this.systemMessageId(model.systemMessageId);
            this.userMessageId(model.userMessageId);
        }

        public final ActionReview.Builder getActionReview() {
            return this.actionReview != null ? this.actionReview.toBuilder() : null;
        }

        public final void setActionReview(ActionReview.BuilderImpl actionReview) {
            this.actionReview = actionReview != null ? actionReview.build() : null;
        }

        @Override
        public final Builder actionReview(ActionReview actionReview) {
            this.actionReview = actionReview;
            return this;
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final List<AttachmentOutput.Builder> getFailedAttachments() {
            List<AttachmentOutput.Builder> result = AttachmentsOutputCopier.copyToBuilder(this.failedAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAttachments(Collection<AttachmentOutput.BuilderImpl> failedAttachments) {
            this.failedAttachments = AttachmentsOutputCopier.copyFromBuilder(failedAttachments);
        }

        @Override
        public final Builder failedAttachments(Collection<AttachmentOutput> failedAttachments) {
            this.failedAttachments = AttachmentsOutputCopier.copy(failedAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAttachments(AttachmentOutput ... failedAttachments) {
            this.failedAttachments(Arrays.asList(failedAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAttachments(Consumer<AttachmentOutput.Builder> ... failedAttachments) {
            this.failedAttachments(Stream.of(failedAttachments).map(c -> (AttachmentOutput)((AttachmentOutput.Builder)AttachmentOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttributions() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttributions(Collection<SourceAttribution.BuilderImpl> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copyFromBuilder(sourceAttributions);
        }

        @Override
        public final Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copy(sourceAttributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(SourceAttribution ... sourceAttributions) {
            this.sourceAttributions(Arrays.asList(sourceAttributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(Consumer<SourceAttribution.Builder> ... sourceAttributions) {
            this.sourceAttributions(Stream.of(sourceAttributions).map(c -> (SourceAttribution)((SourceAttribution.Builder)SourceAttribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSystemMessage() {
            return this.systemMessage;
        }

        public final void setSystemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
        }

        @Override
        public final Builder systemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public final String getSystemMessageId() {
            return this.systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final String getUserMessageId() {
            return this.userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        @Override
        public ChatSyncResponse build() {
            return new ChatSyncResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChatSyncResponse> {
        public Builder actionReview(ActionReview var1);

        default public Builder actionReview(Consumer<ActionReview.Builder> actionReview) {
            return this.actionReview((ActionReview)((ActionReview.Builder)ActionReview.builder().applyMutation(actionReview)).build());
        }

        public Builder conversationId(String var1);

        public Builder failedAttachments(Collection<AttachmentOutput> var1);

        public Builder failedAttachments(AttachmentOutput ... var1);

        public Builder failedAttachments(Consumer<AttachmentOutput.Builder> ... var1);

        public Builder sourceAttributions(Collection<SourceAttribution> var1);

        public Builder sourceAttributions(SourceAttribution ... var1);

        public Builder sourceAttributions(Consumer<SourceAttribution.Builder> ... var1);

        public Builder systemMessage(String var1);

        public Builder systemMessageId(String var1);

        public Builder userMessageId(String var1);
    }
}

