/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.Document;
import software.amazon.awssdk.services.qbusiness.model.DocumentsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutDocumentRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, BatchPutDocumentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::applicationId)).setter(BatchPutDocumentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_SYNC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceSyncId").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::dataSourceSyncId)).setter(BatchPutDocumentRequest.setter(Builder::dataSourceSyncId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceSyncId").build()}).build();
    private static final SdkField<List<Document>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documents").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::documents)).setter(BatchPutDocumentRequest.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::indexId)).setter(BatchPutDocumentRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::roleArn)).setter(BatchPutDocumentRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, DATA_SOURCE_SYNC_ID_FIELD, DOCUMENTS_FIELD, INDEX_ID_FIELD, ROLE_ARN_FIELD));
    private final String applicationId;
    private final String dataSourceSyncId;
    private final List<Document> documents;
    private final String indexId;
    private final String roleArn;

    private BatchPutDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataSourceSyncId = builder.dataSourceSyncId;
        this.documents = builder.documents;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String dataSourceSyncId() {
        return this.dataSourceSyncId;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<Document> documents() {
        return this.documents;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceSyncId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentRequest)) {
            return false;
        }
        BatchPutDocumentRequest other = (BatchPutDocumentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.dataSourceSyncId(), other.dataSourceSyncId()) && this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutDocumentRequest").add("ApplicationId", (Object)this.applicationId()).add("DataSourceSyncId", (Object)this.dataSourceSyncId()).add("Documents", this.hasDocuments() ? this.documents() : null).add("IndexId", (Object)this.indexId()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "dataSourceSyncId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceSyncId()));
            }
            case "documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDocumentRequest, T> g) {
        return obj -> g.apply((BatchPutDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String dataSourceSyncId;
        private List<Document> documents = DefaultSdkAutoConstructList.getInstance();
        private String indexId;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDocumentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.dataSourceSyncId(model.dataSourceSyncId);
            this.documents(model.documents);
            this.indexId(model.indexId);
            this.roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataSourceSyncId() {
            return this.dataSourceSyncId;
        }

        public final void setDataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
        }

        @Override
        public final Builder dataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
            return this;
        }

        public final List<Document.Builder> getDocuments() {
            List<Document.Builder> result = DocumentsCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<Document.BuilderImpl> documents) {
            this.documents = DocumentsCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<Document> documents) {
            this.documents = DocumentsCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Document ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<Document.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (Document)((Document.Builder)Document.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutDocumentRequest build() {
            return new BatchPutDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutDocumentRequest> {
        public Builder applicationId(String var1);

        public Builder dataSourceSyncId(String var1);

        public Builder documents(Collection<Document> var1);

        public Builder documents(Document ... var1);

        public Builder documents(Consumer<Document.Builder> ... var1);

        public Builder indexId(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

