/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttributeType {
    STRING("STRING"),
    STRING_LIST("STRING_LIST"),
    NUMBER("NUMBER"),
    DATE("DATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttributeType> VALUE_MAP;
    private final String value;

    private AttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttributeType> knownValues() {
        EnumSet<AttributeType> knownValues = EnumSet.allOf(AttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttributeType.class, AttributeType::toString);
    }
}

