/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detail data for a resource sync attempt activated by a push to a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSyncAttempt implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSyncAttempt.Builder, ResourceSyncAttempt> {
    private static final SdkField<List<ResourceSyncEvent>> EVENTS_FIELD = SdkField
            .<List<ResourceSyncEvent>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(ResourceSyncAttempt::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceSyncEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceSyncEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Revision> INITIAL_REVISION_FIELD = SdkField.<Revision> builder(MarshallingType.SDK_POJO)
            .memberName("initialRevision").getter(getter(ResourceSyncAttempt::initialRevision))
            .setter(setter(Builder::initialRevision)).constructor(Revision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRevision").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(ResourceSyncAttempt::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ResourceSyncAttempt::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(ResourceSyncAttempt::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<Revision> TARGET_REVISION_FIELD = SdkField.<Revision> builder(MarshallingType.SDK_POJO)
            .memberName("targetRevision").getter(getter(ResourceSyncAttempt::targetRevision))
            .setter(setter(Builder::targetRevision)).constructor(Revision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            INITIAL_REVISION_FIELD, STARTED_AT_FIELD, STATUS_FIELD, TARGET_FIELD, TARGET_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResourceSyncEvent> events;

    private final Revision initialRevision;

    private final Instant startedAt;

    private final String status;

    private final String target;

    private final Revision targetRevision;

    private ResourceSyncAttempt(BuilderImpl builder) {
        this.events = builder.events;
        this.initialRevision = builder.initialRevision;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.target = builder.target;
        this.targetRevision = builder.targetRevision;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of events with detail data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return An array of events with detail data.
     */
    public final List<ResourceSyncEvent> events() {
        return events;
    }

    /**
     * <p>
     * Detail data for the initial repository commit, path and push.
     * </p>
     * 
     * @return Detail data for the initial repository commit, path and push.
     */
    public final Revision initialRevision() {
        return initialRevision;
    }

    /**
     * <p>
     * The time when the sync attempt started.
     * </p>
     * 
     * @return The time when the sync attempt started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The status of the sync attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the sync attempt.
     * @see ResourceSyncStatus
     */
    public final ResourceSyncStatus status() {
        return ResourceSyncStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the sync attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the sync attempt.
     * @see ResourceSyncStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The resource that is synced to.
     * </p>
     * 
     * @return The resource that is synced to.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * Detail data for the target revision.
     * </p>
     * 
     * @return Detail data for the target revision.
     */
    public final Revision targetRevision() {
        return targetRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(initialRevision());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSyncAttempt)) {
            return false;
        }
        ResourceSyncAttempt other = (ResourceSyncAttempt) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(initialRevision(), other.initialRevision()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(target(), other.target())
                && Objects.equals(targetRevision(), other.targetRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSyncAttempt").add("Events", hasEvents() ? events() : null)
                .add("InitialRevision", initialRevision()).add("StartedAt", startedAt()).add("Status", statusAsString())
                .add("Target", target()).add("TargetRevision", targetRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "initialRevision":
            return Optional.ofNullable(clazz.cast(initialRevision()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "targetRevision":
            return Optional.ofNullable(clazz.cast(targetRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSyncAttempt, T> g) {
        return obj -> g.apply((ResourceSyncAttempt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSyncAttempt> {
        /**
         * <p>
         * An array of events with detail data.
         * </p>
         * 
         * @param events
         *        An array of events with detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<ResourceSyncEvent> events);

        /**
         * <p>
         * An array of events with detail data.
         * </p>
         * 
         * @param events
         *        An array of events with detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(ResourceSyncEvent... events);

        /**
         * <p>
         * An array of events with detail data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.ResourceSyncEvent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.proton.model.ResourceSyncEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.ResourceSyncEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #events(List<ResourceSyncEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.ResourceSyncEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<ResourceSyncEvent>)
         */
        Builder events(Consumer<ResourceSyncEvent.Builder>... events);

        /**
         * <p>
         * Detail data for the initial repository commit, path and push.
         * </p>
         * 
         * @param initialRevision
         *        Detail data for the initial repository commit, path and push.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialRevision(Revision initialRevision);

        /**
         * <p>
         * Detail data for the initial repository commit, path and push.
         * </p>
         * This is a convenience method that creates an instance of the {@link Revision.Builder} avoiding the need to
         * create one manually via {@link Revision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Revision.Builder#build()} is called immediately and its result is
         * passed to {@link #initialRevision(Revision)}.
         * 
         * @param initialRevision
         *        a consumer that will call methods on {@link Revision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialRevision(Revision)
         */
        default Builder initialRevision(Consumer<Revision.Builder> initialRevision) {
            return initialRevision(Revision.builder().applyMutation(initialRevision).build());
        }

        /**
         * <p>
         * The time when the sync attempt started.
         * </p>
         * 
         * @param startedAt
         *        The time when the sync attempt started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The status of the sync attempt.
         * </p>
         * 
         * @param status
         *        The status of the sync attempt.
         * @see ResourceSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSyncStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the sync attempt.
         * </p>
         * 
         * @param status
         *        The status of the sync attempt.
         * @see ResourceSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSyncStatus
         */
        Builder status(ResourceSyncStatus status);

        /**
         * <p>
         * The resource that is synced to.
         * </p>
         * 
         * @param target
         *        The resource that is synced to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * Detail data for the target revision.
         * </p>
         * 
         * @param targetRevision
         *        Detail data for the target revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRevision(Revision targetRevision);

        /**
         * <p>
         * Detail data for the target revision.
         * </p>
         * This is a convenience method that creates an instance of the {@link Revision.Builder} avoiding the need to
         * create one manually via {@link Revision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Revision.Builder#build()} is called immediately and its result is
         * passed to {@link #targetRevision(Revision)}.
         * 
         * @param targetRevision
         *        a consumer that will call methods on {@link Revision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRevision(Revision)
         */
        default Builder targetRevision(Consumer<Revision.Builder> targetRevision) {
            return targetRevision(Revision.builder().applyMutation(targetRevision).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ResourceSyncEvent> events = DefaultSdkAutoConstructList.getInstance();

        private Revision initialRevision;

        private Instant startedAt;

        private String status;

        private String target;

        private Revision targetRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSyncAttempt model) {
            events(model.events);
            initialRevision(model.initialRevision);
            startedAt(model.startedAt);
            status(model.status);
            target(model.target);
            targetRevision(model.targetRevision);
        }

        public final List<ResourceSyncEvent.Builder> getEvents() {
            List<ResourceSyncEvent.Builder> result = ResourceSyncEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<ResourceSyncEvent.BuilderImpl> events) {
            this.events = ResourceSyncEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<ResourceSyncEvent> events) {
            this.events = ResourceSyncEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ResourceSyncEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ResourceSyncEvent.Builder>... events) {
            events(Stream.of(events).map(c -> ResourceSyncEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Revision.Builder getInitialRevision() {
            return initialRevision != null ? initialRevision.toBuilder() : null;
        }

        public final void setInitialRevision(Revision.BuilderImpl initialRevision) {
            this.initialRevision = initialRevision != null ? initialRevision.build() : null;
        }

        @Override
        public final Builder initialRevision(Revision initialRevision) {
            this.initialRevision = initialRevision;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSyncStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Revision.Builder getTargetRevision() {
            return targetRevision != null ? targetRevision.toBuilder() : null;
        }

        public final void setTargetRevision(Revision.BuilderImpl targetRevision) {
            this.targetRevision = targetRevision != null ? targetRevision.build() : null;
        }

        @Override
        public final Builder targetRevision(Revision targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        @Override
        public ResourceSyncAttempt build() {
            return new ResourceSyncAttempt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
