/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesSummaryResponse extends ProtonResponse implements
        ToCopyableBuilder<GetResourcesSummaryResponse.Builder, GetResourcesSummaryResponse> {
    private static final SdkField<CountsSummary> COUNTS_FIELD = SdkField.<CountsSummary> builder(MarshallingType.SDK_POJO)
            .memberName("counts").getter(getter(GetResourcesSummaryResponse::counts)).setter(setter(Builder::counts))
            .constructor(CountsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTS_FIELD));

    private final CountsSummary counts;

    private GetResourcesSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.counts = builder.counts;
    }

    /**
     * <p>
     * Summary counts of each Proton resource type.
     * </p>
     * 
     * @return Summary counts of each Proton resource type.
     */
    public final CountsSummary counts() {
        return counts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(counts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesSummaryResponse)) {
            return false;
        }
        GetResourcesSummaryResponse other = (GetResourcesSummaryResponse) obj;
        return Objects.equals(counts(), other.counts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesSummaryResponse").add("Counts", counts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "counts":
            return Optional.ofNullable(clazz.cast(counts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesSummaryResponse, T> g) {
        return obj -> g.apply((GetResourcesSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcesSummaryResponse> {
        /**
         * <p>
         * Summary counts of each Proton resource type.
         * </p>
         * 
         * @param counts
         *        Summary counts of each Proton resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counts(CountsSummary counts);

        /**
         * <p>
         * Summary counts of each Proton resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountsSummary.Builder} avoiding the need
         * to create one manually via {@link CountsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountsSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #counts(CountsSummary)}.
         * 
         * @param counts
         *        a consumer that will call methods on {@link CountsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #counts(CountsSummary)
         */
        default Builder counts(Consumer<CountsSummary.Builder> counts) {
            return counts(CountsSummary.builder().applyMutation(counts).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private CountsSummary counts;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesSummaryResponse model) {
            super(model);
            counts(model.counts);
        }

        public final CountsSummary.Builder getCounts() {
            return counts != null ? counts.toBuilder() : null;
        }

        public final void setCounts(CountsSummary.BuilderImpl counts) {
            this.counts = counts != null ? counts.build() : null;
        }

        @Override
        public final Builder counts(CountsSummary counts) {
            this.counts = counts;
            return this;
        }

        @Override
        public GetResourcesSummaryResponse build() {
            return new GetResourcesSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
