/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListComponentProvisionedResourcesIterable
implements SdkIterable<ListComponentProvisionedResourcesResponse> {
    private final ProtonClient client;
    private final ListComponentProvisionedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentProvisionedResourcesIterable(ProtonClient client, ListComponentProvisionedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComponentProvisionedResourcesResponseFetcher();
    }

    public Iterator<ListComponentProvisionedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisionedResource> provisionedResources() {
        Function<ListComponentProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComponentProvisionedResourcesResponseFetcher
    implements SyncPageFetcher<ListComponentProvisionedResourcesResponse> {
        private ListComponentProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentProvisionedResourcesResponse nextPage(ListComponentProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListComponentProvisionedResourcesIterable.this.client.listComponentProvisionedResources(ListComponentProvisionedResourcesIterable.this.firstRequest);
            }
            return ListComponentProvisionedResourcesIterable.this.client.listComponentProvisionedResources((ListComponentProvisionedResourcesRequest)((Object)ListComponentProvisionedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

