/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceIdentifierFilterKeys {
    STATUS("STATUS"),
    ORDER("ORDER"),
    TRAFFIC_GROUP("TRAFFIC_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceIdentifierFilterKeys> VALUE_MAP;
    private final String value;

    private DeviceIdentifierFilterKeys(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceIdentifierFilterKeys fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceIdentifierFilterKeys> knownValues() {
        EnumSet<DeviceIdentifierFilterKeys> knownValues = EnumSet.allOf(DeviceIdentifierFilterKeys.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceIdentifierFilterKeys.class, DeviceIdentifierFilterKeys::toString);
    }
}

