/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPriceListsRequest extends PricingRequest implements
        ToCopyableBuilder<ListPriceListsRequest.Builder, ListPriceListsRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(ListPriceListsRequest::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EffectiveDate").getter(getter(ListPriceListsRequest::effectiveDate))
            .setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").build()).build();

    private static final SdkField<String> REGION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionCode").getter(getter(ListPriceListsRequest::regionCode)).setter(setter(Builder::regionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionCode").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ListPriceListsRequest::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPriceListsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPriceListsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            EFFECTIVE_DATE_FIELD, REGION_CODE_FIELD, CURRENCY_CODE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String serviceCode;

    private final Instant effectiveDate;

    private final String regionCode;

    private final String currencyCode;

    private final String nextToken;

    private final Integer maxResults;

    private ListPriceListsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.effectiveDate = builder.effectiveDate;
        this.regionCode = builder.regionCode;
        this.currencyCode = builder.currencyCode;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The service code or the Savings Plan service code for the attributes that you want to retrieve. For example, to
     * get the list of applicable Amazon EC2 price lists, use <code>AmazonEC2</code>. For a full list of service codes
     * containing On-Demand and Reserved Instance (RI) pricing, use the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion"
     * > <code>DescribeServices</code> </a> API.
     * </p>
     * <p>
     * To retrieve the Compute Savings Plan price lists, use <code>ComputeSavingsPlans</code>. To retrieve Machine
     * Learning Savings Plans price lists, use <code>MachineLearningSavingsPlans</code>.
     * </p>
     * 
     * @return The service code or the Savings Plan service code for the attributes that you want to retrieve. For
     *         example, to get the list of applicable Amazon EC2 price lists, use <code>AmazonEC2</code>. For a full
     *         list of service codes containing On-Demand and Reserved Instance (RI) pricing, use the <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion"
     *         > <code>DescribeServices</code> </a> API.</p>
     *         <p>
     *         To retrieve the Compute Savings Plan price lists, use <code>ComputeSavingsPlans</code>. To retrieve
     *         Machine Learning Savings Plans price lists, use <code>MachineLearningSavingsPlans</code>.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The date that the Price List file prices are effective from.
     * </p>
     * 
     * @return The date that the Price List file prices are effective from.
     */
    public final Instant effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list only for
     * the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is specified, you retrieve
     * price lists for all applicable Regions. The available <code>RegionCode</code> list can be retrieved from <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html">
     * <code>GetAttributeValues</code> </a> API.
     * </p>
     * 
     * @return This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list
     *         only for the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is
     *         specified, you retrieve price lists for all applicable Regions. The available <code>RegionCode</code>
     *         list can be retrieved from <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html"
     *         > <code>GetAttributeValues</code> </a> API.
     */
    public final String regionCode() {
        return regionCode;
    }

    /**
     * <p>
     * The three alphabetical character ISO-4217 currency code that the Price List files are denominated in.
     * </p>
     * 
     * @return The three alphabetical character ISO-4217 currency code that the Price List files are denominated in.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results that you want to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results that you want to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPriceListsRequest)) {
            return false;
        }
        ListPriceListsRequest other = (ListPriceListsRequest) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(regionCode(), other.regionCode()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPriceListsRequest").add("ServiceCode", serviceCode()).add("EffectiveDate", effectiveDate())
                .add("RegionCode", regionCode()).add("CurrencyCode", currencyCode()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "EffectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "RegionCode":
            return Optional.ofNullable(clazz.cast(regionCode()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPriceListsRequest, T> g) {
        return obj -> g.apply((ListPriceListsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PricingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPriceListsRequest> {
        /**
         * <p>
         * The service code or the Savings Plan service code for the attributes that you want to retrieve. For example,
         * to get the list of applicable Amazon EC2 price lists, use <code>AmazonEC2</code>. For a full list of service
         * codes containing On-Demand and Reserved Instance (RI) pricing, use the <a href=
         * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion"
         * > <code>DescribeServices</code> </a> API.
         * </p>
         * <p>
         * To retrieve the Compute Savings Plan price lists, use <code>ComputeSavingsPlans</code>. To retrieve Machine
         * Learning Savings Plans price lists, use <code>MachineLearningSavingsPlans</code>.
         * </p>
         * 
         * @param serviceCode
         *        The service code or the Savings Plan service code for the attributes that you want to retrieve. For
         *        example, to get the list of applicable Amazon EC2 price lists, use <code>AmazonEC2</code>. For a full
         *        list of service codes containing On-Demand and Reserved Instance (RI) pricing, use the <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion"
         *        > <code>DescribeServices</code> </a> API.</p>
         *        <p>
         *        To retrieve the Compute Savings Plan price lists, use <code>ComputeSavingsPlans</code>. To retrieve
         *        Machine Learning Savings Plans price lists, use <code>MachineLearningSavingsPlans</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The date that the Price List file prices are effective from.
         * </p>
         * 
         * @param effectiveDate
         *        The date that the Price List file prices are effective from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(Instant effectiveDate);

        /**
         * <p>
         * This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list only
         * for the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is specified, you
         * retrieve price lists for all applicable Regions. The available <code>RegionCode</code> list can be retrieved
         * from <a href=
         * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html">
         * <code>GetAttributeValues</code> </a> API.
         * </p>
         * 
         * @param regionCode
         *        This is used to filter the Price List by Amazon Web Services Region. For example, to get the price
         *        list only for the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is
         *        specified, you retrieve price lists for all applicable Regions. The available <code>RegionCode</code>
         *        list can be retrieved from <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html"
         *        > <code>GetAttributeValues</code> </a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionCode(String regionCode);

        /**
         * <p>
         * The three alphabetical character ISO-4217 currency code that the Price List files are denominated in.
         * </p>
         * 
         * @param currencyCode
         *        The three alphabetical character ISO-4217 currency code that the Price List files are denominated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The pagination token that indicates the next set of results that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PricingRequest.BuilderImpl implements Builder {
        private String serviceCode;

        private Instant effectiveDate;

        private String regionCode;

        private String currencyCode;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPriceListsRequest model) {
            super(model);
            serviceCode(model.serviceCode);
            effectiveDate(model.effectiveDate);
            regionCode(model.regionCode);
            currencyCode(model.currencyCode);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final Instant getEffectiveDate() {
            return effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final String getRegionCode() {
            return regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPriceListsRequest build() {
            return new ListPriceListsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
