/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum VoiceId {
    ADITI("Aditi"),

    AMY("Amy"),

    ASTRID("Astrid"),

    BIANCA("Bianca"),

    BRIAN("Brian"),

    CAMILA("Camila"),

    CARLA("Carla"),

    CARMEN("Carmen"),

    CELINE("Celine"),

    CHANTAL("Chantal"),

    CONCHITA("Conchita"),

    CRISTIANO("Cristiano"),

    DORA("Dora"),

    EMMA("Emma"),

    ENRIQUE("Enrique"),

    EWA("Ewa"),

    FILIZ("Filiz"),

    GABRIELLE("Gabrielle"),

    GERAINT("Geraint"),

    GIORGIO("Giorgio"),

    GWYNETH("Gwyneth"),

    HANS("Hans"),

    INES("Ines"),

    IVY("Ivy"),

    JACEK("Jacek"),

    JAN("Jan"),

    JOANNA("Joanna"),

    JOEY("Joey"),

    JUSTIN("Justin"),

    KARL("Karl"),

    KENDRA("Kendra"),

    KEVIN("Kevin"),

    KIMBERLY("Kimberly"),

    LEA("Lea"),

    LIV("Liv"),

    LOTTE("Lotte"),

    LUCIA("Lucia"),

    LUPE("Lupe"),

    MADS("Mads"),

    MAJA("Maja"),

    MARLENE("Marlene"),

    MATHIEU("Mathieu"),

    MATTHEW("Matthew"),

    MAXIM("Maxim"),

    MIA("Mia"),

    MIGUEL("Miguel"),

    MIZUKI("Mizuki"),

    NAJA("Naja"),

    NICOLE("Nicole"),

    OLIVIA("Olivia"),

    PENELOPE("Penelope"),

    RAVEENA("Raveena"),

    RICARDO("Ricardo"),

    RUBEN("Ruben"),

    RUSSELL("Russell"),

    SALLI("Salli"),

    SEOYEON("Seoyeon"),

    TAKUMI("Takumi"),

    TATYANA("Tatyana"),

    VICKI("Vicki"),

    VITORIA("Vitoria"),

    ZEINA("Zeina"),

    ZHIYU("Zhiyu"),

    ARIA("Aria"),

    AYANDA("Ayanda"),

    ARLET("Arlet"),

    HANNAH("Hannah"),

    ARTHUR("Arthur"),

    DANIEL("Daniel"),

    LIAM("Liam"),

    PEDRO("Pedro"),

    KAJAL("Kajal"),

    HIUJIN("Hiujin"),

    LAURA("Laura"),

    ELIN("Elin"),

    IDA("Ida"),

    SUVI("Suvi"),

    OLA("Ola"),

    HALA("Hala"),

    ANDRES("Andres"),

    SERGIO("Sergio"),

    REMI("Remi"),

    ADRIANO("Adriano"),

    THIAGO("Thiago"),

    RUTH("Ruth"),

    STEPHEN("Stephen"),

    KAZUHA("Kazuha"),

    TOMOKO("Tomoko"),

    NIAMH("Niamh"),

    SOFIE("Sofie"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VoiceId> VALUE_MAP = EnumUtils.uniqueIndex(VoiceId.class, VoiceId::toString);

    private final String value;

    private VoiceId(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return VoiceId corresponding to the value
     */
    public static VoiceId fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link VoiceId}s
     */
    public static Set<VoiceId> knownValues() {
        Set<VoiceId> knownValues = EnumSet.allOf(VoiceId.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
