/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum LanguageCode {
    ARB("arb"),

    CMN_CN("cmn-CN"),

    CY_GB("cy-GB"),

    DA_DK("da-DK"),

    DE_DE("de-DE"),

    EN_AU("en-AU"),

    EN_GB("en-GB"),

    EN_GB_WLS("en-GB-WLS"),

    EN_IN("en-IN"),

    EN_US("en-US"),

    ES_ES("es-ES"),

    ES_MX("es-MX"),

    ES_US("es-US"),

    FR_CA("fr-CA"),

    FR_FR("fr-FR"),

    IS_IS("is-IS"),

    IT_IT("it-IT"),

    JA_JP("ja-JP"),

    HI_IN("hi-IN"),

    KO_KR("ko-KR"),

    NB_NO("nb-NO"),

    NL_NL("nl-NL"),

    PL_PL("pl-PL"),

    PT_BR("pt-BR"),

    PT_PT("pt-PT"),

    RO_RO("ro-RO"),

    RU_RU("ru-RU"),

    SV_SE("sv-SE"),

    TR_TR("tr-TR"),

    EN_NZ("en-NZ"),

    EN_ZA("en-ZA"),

    CA_ES("ca-ES"),

    DE_AT("de-AT"),

    YUE_CN("yue-CN"),

    AR_AE("ar-AE"),

    FI_FI("fi-FI"),

    EN_IE("en-IE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageCode> VALUE_MAP = EnumUtils.uniqueIndex(LanguageCode.class, LanguageCode::toString);

    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LanguageCode corresponding to the value
     */
    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LanguageCode}s
     */
    public static Set<LanguageCode> knownValues() {
        Set<LanguageCode> knownValues = EnumSet.allOf(LanguageCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
