/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.SelfManagedKafkaAccessConfigurationCredentials;
import software.amazon.awssdk.services.pipes.model.SelfManagedKafkaAccessConfigurationVpc;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipeSourceSelfManagedKafkaParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatePipeSourceSelfManagedKafkaParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(UpdatePipeSourceSelfManagedKafkaParameters.getter(UpdatePipeSourceSelfManagedKafkaParameters::batchSize)).setter(UpdatePipeSourceSelfManagedKafkaParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<SelfManagedKafkaAccessConfigurationCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(UpdatePipeSourceSelfManagedKafkaParameters.getter(UpdatePipeSourceSelfManagedKafkaParameters::credentials)).setter(UpdatePipeSourceSelfManagedKafkaParameters.setter(Builder::credentials)).constructor(SelfManagedKafkaAccessConfigurationCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(UpdatePipeSourceSelfManagedKafkaParameters.getter(UpdatePipeSourceSelfManagedKafkaParameters::maximumBatchingWindowInSeconds)).setter(UpdatePipeSourceSelfManagedKafkaParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<String> SERVER_ROOT_CA_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerRootCaCertificate").getter(UpdatePipeSourceSelfManagedKafkaParameters.getter(UpdatePipeSourceSelfManagedKafkaParameters::serverRootCaCertificate)).setter(UpdatePipeSourceSelfManagedKafkaParameters.setter(Builder::serverRootCaCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerRootCaCertificate").build()}).build();
    private static final SdkField<SelfManagedKafkaAccessConfigurationVpc> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(UpdatePipeSourceSelfManagedKafkaParameters.getter(UpdatePipeSourceSelfManagedKafkaParameters::vpc)).setter(UpdatePipeSourceSelfManagedKafkaParameters.setter(Builder::vpc)).constructor(SelfManagedKafkaAccessConfigurationVpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD, CREDENTIALS_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, SERVER_ROOT_CA_CERTIFICATE_FIELD, VPC_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer batchSize;
    private final SelfManagedKafkaAccessConfigurationCredentials credentials;
    private final Integer maximumBatchingWindowInSeconds;
    private final String serverRootCaCertificate;
    private final SelfManagedKafkaAccessConfigurationVpc vpc;

    private UpdatePipeSourceSelfManagedKafkaParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.serverRootCaCertificate = builder.serverRootCaCertificate;
        this.vpc = builder.vpc;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final SelfManagedKafkaAccessConfigurationCredentials credentials() {
        return this.credentials;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final String serverRootCaCertificate() {
        return this.serverRootCaCertificate;
    }

    public final SelfManagedKafkaAccessConfigurationVpc vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverRootCaCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceSelfManagedKafkaParameters)) {
            return false;
        }
        UpdatePipeSourceSelfManagedKafkaParameters other = (UpdatePipeSourceSelfManagedKafkaParameters)obj;
        return Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.serverRootCaCertificate(), other.serverRootCaCertificate()) && Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipeSourceSelfManagedKafkaParameters").add("BatchSize", (Object)this.batchSize()).add("Credentials", (Object)this.credentials()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("ServerRootCaCertificate", (Object)this.serverRootCaCertificate()).add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "ServerRootCaCertificate": {
                return Optional.ofNullable(clazz.cast(this.serverRootCaCertificate()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceSelfManagedKafkaParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceSelfManagedKafkaParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer batchSize;
        private SelfManagedKafkaAccessConfigurationCredentials credentials;
        private Integer maximumBatchingWindowInSeconds;
        private String serverRootCaCertificate;
        private SelfManagedKafkaAccessConfigurationVpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceSelfManagedKafkaParameters model) {
            this.batchSize(model.batchSize);
            this.credentials(model.credentials);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.serverRootCaCertificate(model.serverRootCaCertificate);
            this.vpc(model.vpc);
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(SelfManagedKafkaAccessConfigurationCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(SelfManagedKafkaAccessConfigurationCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final String getServerRootCaCertificate() {
            return this.serverRootCaCertificate;
        }

        public final void setServerRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
        }

        @Override
        public final Builder serverRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationVpc.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(SelfManagedKafkaAccessConfigurationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(SelfManagedKafkaAccessConfigurationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public UpdatePipeSourceSelfManagedKafkaParameters build() {
            return new UpdatePipeSourceSelfManagedKafkaParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatePipeSourceSelfManagedKafkaParameters> {
        public Builder batchSize(Integer var1);

        public Builder credentials(SelfManagedKafkaAccessConfigurationCredentials var1);

        default public Builder credentials(Consumer<SelfManagedKafkaAccessConfigurationCredentials.Builder> credentials) {
            return this.credentials((SelfManagedKafkaAccessConfigurationCredentials)((SelfManagedKafkaAccessConfigurationCredentials.Builder)SelfManagedKafkaAccessConfigurationCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder serverRootCaCertificate(String var1);

        public Builder vpc(SelfManagedKafkaAccessConfigurationVpc var1);

        default public Builder vpc(Consumer<SelfManagedKafkaAccessConfigurationVpc.Builder> vpc) {
            return this.vpc((SelfManagedKafkaAccessConfigurationVpc)((SelfManagedKafkaAccessConfigurationVpc.Builder)SelfManagedKafkaAccessConfigurationVpc.builder().applyMutation(vpc)).build());
        }
    }
}

