/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.MQBrokerAccessCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipeSourceRabbitMQBrokerParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatePipeSourceRabbitMQBrokerParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(UpdatePipeSourceRabbitMQBrokerParameters.getter(UpdatePipeSourceRabbitMQBrokerParameters::batchSize)).setter(UpdatePipeSourceRabbitMQBrokerParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<MQBrokerAccessCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(UpdatePipeSourceRabbitMQBrokerParameters.getter(UpdatePipeSourceRabbitMQBrokerParameters::credentials)).setter(UpdatePipeSourceRabbitMQBrokerParameters.setter(Builder::credentials)).constructor(MQBrokerAccessCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(UpdatePipeSourceRabbitMQBrokerParameters.getter(UpdatePipeSourceRabbitMQBrokerParameters::maximumBatchingWindowInSeconds)).setter(UpdatePipeSourceRabbitMQBrokerParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD, CREDENTIALS_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer batchSize;
    private final MQBrokerAccessCredentials credentials;
    private final Integer maximumBatchingWindowInSeconds;

    private UpdatePipeSourceRabbitMQBrokerParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final MQBrokerAccessCredentials credentials() {
        return this.credentials;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceRabbitMQBrokerParameters)) {
            return false;
        }
        UpdatePipeSourceRabbitMQBrokerParameters other = (UpdatePipeSourceRabbitMQBrokerParameters)obj;
        return Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipeSourceRabbitMQBrokerParameters").add("BatchSize", (Object)this.batchSize()).add("Credentials", (Object)this.credentials()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceRabbitMQBrokerParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceRabbitMQBrokerParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer batchSize;
        private MQBrokerAccessCredentials credentials;
        private Integer maximumBatchingWindowInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceRabbitMQBrokerParameters model) {
            this.batchSize(model.batchSize);
            this.credentials(model.credentials);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final MQBrokerAccessCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(MQBrokerAccessCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(MQBrokerAccessCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public UpdatePipeSourceRabbitMQBrokerParameters build() {
            return new UpdatePipeSourceRabbitMQBrokerParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatePipeSourceRabbitMQBrokerParameters> {
        public Builder batchSize(Integer var1);

        public Builder credentials(MQBrokerAccessCredentials var1);

        default public Builder credentials(Consumer<MQBrokerAccessCredentials.Builder> credentials) {
            return this.credentials((MQBrokerAccessCredentials)((MQBrokerAccessCredentials.Builder)MQBrokerAccessCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder maximumBatchingWindowInSeconds(Integer var1);
    }
}

