/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EcsEnvironmentFileType {
    S3("s3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EcsEnvironmentFileType> VALUE_MAP;
    private final String value;

    private EcsEnvironmentFileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EcsEnvironmentFileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EcsEnvironmentFileType> knownValues() {
        EnumSet<EcsEnvironmentFileType> knownValues = EnumSet.allOf(EcsEnvironmentFileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EcsEnvironmentFileType.class, EcsEnvironmentFileType::toString);
    }
}

