/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata;

public class ListPoolOriginationIdentitiesPublisher
implements SdkPublisher<ListPoolOriginationIdentitiesResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final ListPoolOriginationIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPoolOriginationIdentitiesPublisher(PinpointSmsVoiceV2AsyncClient client, ListPoolOriginationIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPoolOriginationIdentitiesPublisher(PinpointSmsVoiceV2AsyncClient client, ListPoolOriginationIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPoolOriginationIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPoolOriginationIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OriginationIdentityMetadata> originationIdentities() {
        Function<ListPoolOriginationIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.originationIdentities() != null) {
                return response.originationIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPoolOriginationIdentitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPoolOriginationIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListPoolOriginationIdentitiesResponse> {
        private ListPoolOriginationIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoolOriginationIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPoolOriginationIdentitiesResponse> nextPage(ListPoolOriginationIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListPoolOriginationIdentitiesPublisher.this.client.listPoolOriginationIdentities(ListPoolOriginationIdentitiesPublisher.this.firstRequest);
            }
            return ListPoolOriginationIdentitiesPublisher.this.client.listPoolOriginationIdentities((ListPoolOriginationIdentitiesRequest)((Object)ListPoolOriginationIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

