/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation;

public class DescribePhoneNumbersIterable
implements SdkIterable<DescribePhoneNumbersResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribePhoneNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePhoneNumbersIterable(PinpointSmsVoiceV2Client client, DescribePhoneNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePhoneNumbersResponseFetcher();
    }

    public Iterator<DescribePhoneNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PhoneNumberInformation> phoneNumbers() {
        Function<DescribePhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePhoneNumbersResponseFetcher
    implements SyncPageFetcher<DescribePhoneNumbersResponse> {
        private DescribePhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(DescribePhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePhoneNumbersResponse nextPage(DescribePhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return DescribePhoneNumbersIterable.this.client.describePhoneNumbers(DescribePhoneNumbersIterable.this.firstRequest);
            }
            return DescribePhoneNumbersIterable.this.client.describePhoneNumbers((DescribePhoneNumbersRequest)((Object)DescribePhoneNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

