/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation;

public class DescribePoolsPublisher
implements SdkPublisher<DescribePoolsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribePoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePoolsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribePoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePoolsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribePoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PoolInformation> pools() {
        Function<DescribePoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pools() != null) {
                return response.pools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePoolsResponseFetcher
    implements AsyncPageFetcher<DescribePoolsResponse> {
        private DescribePoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePoolsResponse> nextPage(DescribePoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribePoolsPublisher.this.client.describePools(DescribePoolsPublisher.this.firstRequest);
            }
            return DescribePoolsPublisher.this.client.describePools((DescribePoolsRequest)((Object)DescribePoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

