/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation;

public class DescribeOptedOutNumbersPublisher
implements SdkPublisher<DescribeOptedOutNumbersResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeOptedOutNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOptedOutNumbersPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeOptedOutNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOptedOutNumbersPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeOptedOutNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOptedOutNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOptedOutNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OptedOutNumberInformation> optedOutNumbers() {
        Function<DescribeOptedOutNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.optedOutNumbers() != null) {
                return response.optedOutNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOptedOutNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeOptedOutNumbersResponseFetcher
    implements AsyncPageFetcher<DescribeOptedOutNumbersResponse> {
        private DescribeOptedOutNumbersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptedOutNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOptedOutNumbersResponse> nextPage(DescribeOptedOutNumbersResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptedOutNumbersPublisher.this.client.describeOptedOutNumbers(DescribeOptedOutNumbersPublisher.this.firstRequest);
            }
            return DescribeOptedOutNumbersPublisher.this.client.describeOptedOutNumbers((DescribeOptedOutNumbersRequest)((Object)DescribeOptedOutNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

