/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pinpoint.DefaultPinpointAsyncClient;
import software.amazon.awssdk.services.pinpoint.DefaultPinpointBaseClientBuilder;
import software.amazon.awssdk.services.pinpoint.PinpointAsyncClient;
import software.amazon.awssdk.services.pinpoint.PinpointAsyncClientBuilder;
import software.amazon.awssdk.services.pinpoint.PinpointServiceClientConfiguration;
import software.amazon.awssdk.services.pinpoint.endpoints.PinpointEndpointProvider;

@SdkInternalApi
final class DefaultPinpointAsyncClientBuilder
extends DefaultPinpointBaseClientBuilder<PinpointAsyncClientBuilder, PinpointAsyncClient>
implements PinpointAsyncClientBuilder {
    DefaultPinpointAsyncClientBuilder() {
    }

    @Override
    public DefaultPinpointAsyncClientBuilder endpointProvider(PinpointEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PinpointAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPinpointAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        PinpointServiceClientConfiguration serviceClientConfiguration = PinpointServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultPinpointAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

