/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pi.model.PiRequest;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPerformanceAnalysisReportsRequest
extends PiRequest
implements ToCopyableBuilder<Builder, ListPerformanceAnalysisReportsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(ListPerformanceAnalysisReportsRequest.getter(ListPerformanceAnalysisReportsRequest::serviceTypeAsString)).setter(ListPerformanceAnalysisReportsRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(ListPerformanceAnalysisReportsRequest.getter(ListPerformanceAnalysisReportsRequest::identifier)).setter(ListPerformanceAnalysisReportsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPerformanceAnalysisReportsRequest.getter(ListPerformanceAnalysisReportsRequest::nextToken)).setter(ListPerformanceAnalysisReportsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPerformanceAnalysisReportsRequest.getter(ListPerformanceAnalysisReportsRequest::maxResults)).setter(ListPerformanceAnalysisReportsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> LIST_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ListTags").getter(ListPerformanceAnalysisReportsRequest.getter(ListPerformanceAnalysisReportsRequest::listTags)).setter(ListPerformanceAnalysisReportsRequest.setter(Builder::listTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, IDENTIFIER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIST_TAGS_FIELD));
    private final String serviceType;
    private final String identifier;
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean listTags;

    private ListPerformanceAnalysisReportsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.listTags = builder.listTags;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean listTags() {
        return this.listTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.listTags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPerformanceAnalysisReportsRequest)) {
            return false;
        }
        ListPerformanceAnalysisReportsRequest other = (ListPerformanceAnalysisReportsRequest)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.listTags(), other.listTags());
    }

    public final String toString() {
        return ToString.builder((String)"ListPerformanceAnalysisReportsRequest").add("ServiceType", (Object)this.serviceTypeAsString()).add("Identifier", (Object)this.identifier()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ListTags", (Object)this.listTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ListTags": {
                return Optional.ofNullable(clazz.cast(this.listTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPerformanceAnalysisReportsRequest, T> g) {
        return obj -> g.apply((ListPerformanceAnalysisReportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiRequest.BuilderImpl
    implements Builder {
        private String serviceType;
        private String identifier;
        private String nextToken;
        private Integer maxResults;
        private Boolean listTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPerformanceAnalysisReportsRequest model) {
            super(model);
            this.serviceType(model.serviceType);
            this.identifier(model.identifier);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.listTags(model.listTags);
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getListTags() {
            return this.listTags;
        }

        public final void setListTags(Boolean listTags) {
            this.listTags = listTags;
        }

        @Override
        public final Builder listTags(Boolean listTags) {
            this.listTags = listTags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPerformanceAnalysisReportsRequest build() {
            return new ListPerformanceAnalysisReportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPerformanceAnalysisReportsRequest> {
        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder identifier(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder listTags(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

